// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/sio4.h $
// $Rev: 32770 $
// $Date: 2015-09-07 15:22:27 -0500 (Mon, 07 Sep 2015) $

#ifndef __SIO4_H__
#define __SIO4_H__

#include "gsc_common.h"
#include "gsc_pci9080.h"
#include "gsc_pci9056.h"
#include "sio4_usc.h"



// #defines *******************************************************************

#define SIO4_BASE_NAME						"sio4"

// IOCTL command codes

#define SIO4_IOCTL_REG_READ					OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define SIO4_IOCTL_REG_WRITE				OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define SIO4_IOCTL_REG_MOD					OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define SIO4_IOCTL_QUERY					OS_IOCTL_RW( 3,  4, s32)
#define SIO4_IOCTL_INITIALIZE				OS_IOCTL_RW( 4,  4, s32)
#define SIO4_IOCTL_CBL_MODE					OS_IOCTL_RW( 5,  4, s32)
#define SIO4_IOCTL_CBL_PIN_STATUS			OS_IOCTL_RW( 6,  4, s32)
#define SIO4_IOCTL_FIFO_SPACE_CFG			OS_IOCTL_RW( 7,  4, s32)
#define SIO4_IOCTL_GPIO_DIRECTION_OUT		OS_IOCTL_RW( 8,  4, s32)
#define SIO4_IOCTL_GPIO_INPUT_LATCHING		OS_IOCTL_RW( 9,  4, s32)

#define SIO4_IOCTL_GPIO_INPUT_READ			OS_IOCTL_RW(10,  4, s32)
#define SIO4_IOCTL_GPIO_OUTPUT_WRITE		OS_IOCTL_RW(11,  4, s32)
#define SIO4_IOCTL_GPIO_POLARITY			OS_IOCTL_RW(12,  4, s32)
#define SIO4_IOCTL_GPIO_SENSE_EDGE			OS_IOCTL_RW(13,  4, s32)
#define SIO4_IOCTL_IRQ_GSC_CFG_HIGH			OS_IOCTL_RW(14,  4, s32)
#define SIO4_IOCTL_IRQ_GSC_ENABLE			OS_IOCTL_RW(15,  4, s32)
#define SIO4_IOCTL_IRQ_USC_ENABLE			OS_IOCTL_RW(16,  4, s32)
#define SIO4_IOCTL_LED_CHANNEL				OS_IOCTL_RW(17,  4, s32)
#define SIO4_IOCTL_LED_MAIN					OS_IOCTL_RW(18,  4, s32)
#define SIO4_IOCTL_LOOP_BACK				OS_IOCTL_RW(19,  4, s32)

#define SIO4_IOCTL_OSC_MEASURE				OS_IOCTL_RW(20,  4, s32)
#define SIO4_IOCTL_OSC_PROGRAM				OS_IOCTL_RW(21,  4, s32)
#define SIO4_IOCTL_OSC_REFERENCE			OS_IOCTL_RW(22,  4, s32)
#define SIO4_IOCTL_RX_FIFO_AE				OS_IOCTL_RW(23,  4, s32)
#define SIO4_IOCTL_RX_FIFO_AF				OS_IOCTL_RW(24,  4, s32)
#define SIO4_IOCTL_RX_FIFO_FILL_LEVEL		OS_IOCTL_RW(25,  4, s32)
#define SIO4_IOCTL_RX_FIFO_FULL_CFG			OS_IOCTL_RW(26,  4, s32)
#define SIO4_IOCTL_RX_FIFO_OVERRUN			OS_IOCTL_RW(27,  4, s32)
#define SIO4_IOCTL_RX_FIFO_RESET			OS_IOCTL_RW(28,  4, s32)
#define SIO4_IOCTL_RX_FIFO_STATUS			OS_IOCTL_RW(29,  4, s32)

#define SIO4_IOCTL_RX_FIFO_UNDERRUN			OS_IOCTL_RW(30,  4, s32)
#define SIO4_IOCTL_RX_IO_MODE				OS_IOCTL_RW(31,  4, s32)
#define SIO4_IOCTL_RX_IO_OVERRUN			OS_IOCTL_RW(32,  4, s32)
#define SIO4_IOCTL_RX_IO_PIO_THRESHOLD		OS_IOCTL_RW(33,  4, s32)
#define SIO4_IOCTL_RX_IO_TIMEOUT			OS_IOCTL_RW(34,  4, s32)
#define SIO4_IOCTL_RX_IO_UNDERRUN			OS_IOCTL_RW(35,  4, s32)
#define SIO4_IOCTL_SYNC_LEG_RXD_CFG			OS_IOCTL_RW(36,  4, s32)
#define SIO4_IOCTL_SYNC_LEG_TXD_CFG			OS_IOCTL_RW(37,  4, s32)
#define SIO4_IOCTL_SYNC_MODE				OS_IOCTL_RW(38,  4, s32)
#define SIO4_IOCTL_SYNC_RX_BIT_COUNT		OS_IOCTL_RW(39,  4, s32)

#define SIO4_IOCTL_SYNC_RX_BIT_ORDER		OS_IOCTL_RW(40,  4, s32)
#define SIO4_IOCTL_SYNC_RX_COUNT_ERROR		OS_IOCTL_RW(41,  4, s32)
#define SIO4_IOCTL_SYNC_RX_COUNT_RESET		OS_IOCTL_RW(42,  4, s32)
#define SIO4_IOCTL_SYNC_RX_ENABLE			OS_IOCTL_RW(43,  4, s32)
#define SIO4_IOCTL_SYNC_RX_GAP_ENABLE		OS_IOCTL_RW(44,  4, s32)
#define SIO4_IOCTL_SYNC_RXC_CFG				OS_IOCTL_RW(45,  4, s32)
#define SIO4_IOCTL_SYNC_RXC_POL				OS_IOCTL_RW(46,  4, s32)
#define SIO4_IOCTL_SYNC_RXD_CFG				OS_IOCTL_RW(47,  4, s32)
#define SIO4_IOCTL_SYNC_RXE_CFG				OS_IOCTL_RW(48,  4, s32)
#define SIO4_IOCTL_SYNC_RXE_POL				OS_IOCTL_RW(49,  4, s32)

#define SIO4_IOCTL_SYNC_TX_WORD_SIZE		OS_IOCTL_RW(50,  4, s32)
#define SIO4_IOCTL_SYNC_TX_BIT_ORDER		OS_IOCTL_RW(51,  4, s32)
#define SIO4_IOCTL_SYNC_TX_ENABLE			OS_IOCTL_RW(52,  4, s32)
#define SIO4_IOCTL_SYNC_TX_GAP_SIZE			OS_IOCTL_RW(53,  4, s32)
#define SIO4_IOCTL_SYNC_TXAUXC_CFG			OS_IOCTL_RW(54,  4, s32)
#define SIO4_IOCTL_SYNC_TXC_CFG				OS_IOCTL_RW(55,  4, s32)
#define SIO4_IOCTL_SYNC_TXC_IDLE			OS_IOCTL_RW(56,  4, s32)
#define SIO4_IOCTL_SYNC_TXC_IDLE_CFG		OS_IOCTL_RW(57,  4, s32)
#define SIO4_IOCTL_SYNC_TXC_POL				OS_IOCTL_RW(58,  4, s32)
#define SIO4_IOCTL_SYNC_TXC_SRC				OS_IOCTL_RW(59,  4, s32)

#define SIO4_IOCTL_SYNC_TXD_CFG				OS_IOCTL_RW(60,  4, s32)
#define SIO4_IOCTL_SYNC_TXD_IDLE_CFG		OS_IOCTL_RW(61,  4, s32)
#define SIO4_IOCTL_SYNC_TXE_CFG				OS_IOCTL_RW(62,  4, s32)
#define SIO4_IOCTL_SYNC_TXE_POL				OS_IOCTL_RW(63,  4, s32)
#define SIO4_IOCTL_SYNC_TXSP_CFG			OS_IOCTL_RW(64,  4, s32)
#define SIO4_IOCTL_TIME_STAMP_COUNT			OS_IOCTL_RW(65,  4, s32)
#define SIO4_IOCTL_TIME_STAMP_ENABLE		OS_IOCTL_RW(66,  4, s32)
#define SIO4_IOCTL_TIME_STAMP_SRC			OS_IOCTL_RW(67,  4, s32)
#define SIO4_IOCTL_TIME_STAMP_VAL			OS_IOCTL_RW(68,  4, s32)
#define SIO4_IOCTL_TX_FIFO_AE				OS_IOCTL_RW(69,  4, s32)

#define SIO4_IOCTL_TX_FIFO_AF				OS_IOCTL_RW(70,  4, s32)
#define SIO4_IOCTL_TX_FIFO_EMPTY_CFG		OS_IOCTL_RW(71,  4, s32)
#define SIO4_IOCTL_TX_FIFO_FILL_LEVEL		OS_IOCTL_RW(72,  4, s32)
#define SIO4_IOCTL_TX_FIFO_OVERRUN			OS_IOCTL_RW(73,  4, s32)
#define SIO4_IOCTL_TX_FIFO_RESET			OS_IOCTL_RW(74,  4, s32)
#define SIO4_IOCTL_TX_FIFO_STATUS			OS_IOCTL_RW(75,  4, s32)
#define SIO4_IOCTL_TX_IO_MODE				OS_IOCTL_RW(76,  4, s32)
#define SIO4_IOCTL_TX_IO_OVERRUN			OS_IOCTL_RW(77,  4, s32)
#define SIO4_IOCTL_TX_IO_PIO_THRESHOLD		OS_IOCTL_RW(78,  4, s32)
#define SIO4_IOCTL_TX_IO_TIMEOUT			OS_IOCTL_RW(79,  4, s32)

#define SIO4_IOCTL_XCVR_ENABLE				OS_IOCTL_RW(80,  4, s32)
#define SIO4_IOCTL_XCVR_PROTOCOL			OS_IOCTL_RW(81,  4, s32)
#define SIO4_IOCTL_XCVR_TERM				OS_IOCTL_RW(82,  4, s32)
#define SIO4_IOCTL_Z16_CBL_DCD_CFG			OS_IOCTL_RW(83,  4, s32)
#define SIO4_IOCTL_Z16_CBL_DTR_DSR_CFG		OS_IOCTL_RW(84,  4, s32)
#define SIO4_IOCTL_Z16_CBL_RTS_CFG			OS_IOCTL_RW(85,  4, s32)
#define SIO4_IOCTL_Z16_CBL_TXAUXC_CFG		OS_IOCTL_RW(86,  4, s32)
#define SIO4_IOCTL_Z16_CBL_TXC_CFG			OS_IOCTL_RW(87,  4, s32)
#define SIO4_IOCTL_Z16_CBL_TXD_CFG			OS_IOCTL_RW(88,  4, s32)
#define SIO4_IOCTL_Z16_LEG_RXC				OS_IOCTL_RW(89,  4, s32)

#define SIO4_IOCTL_Z16_LEG_RXD_DCD_CFG		OS_IOCTL_RW(90,  4, s32)
#define SIO4_IOCTL_Z16_LEG_TXC				OS_IOCTL_RW(91,  4, s32)
#define SIO4_IOCTL_Z16_LEG_TXD_CTS_CFG		OS_IOCTL_RW(92,  4, s32)
#define SIO4_IOCTL_Z16_RX_STS_WRD_ENABLE	OS_IOCTL_RW(93,  4, s32)
#define SIO4_IOCTL_Z16_SYNC_BYTE			OS_IOCTL_RW(94,  4, s32)
#define	SIO4_IOCTL_WAIT_EVENT				OS_IOCTL_RW(95, 28, gsc_wait_t)
#define	SIO4_IOCTL_WAIT_CANCEL				OS_IOCTL_RW(96, 28, gsc_wait_t)
#define	SIO4_IOCTL_WAIT_STATUS				OS_IOCTL_RW(97, 28, gsc_wait_t)
#define SIO4_IOCTL_RX_IO_ABORT				OS_IOCTL_RW(98,  4, s32)
#define SIO4_IOCTL_TX_IO_ABORT				OS_IOCTL_RW(99,  4, s32)
//														100		sio4_usc.h
//														...		sio4_usc.h
//														223		sio4_usc.h
#define SIO4_IOCTL_REG_READ_RAW				OS_IOCTL_RW(224, 12, gsc_reg_t)
#define	SIO4_IOCTL_RCC_SW_FIFO_ENABLE		OS_IOCTL_RW(225,  4, s32)
#define	SIO4_IOCTL_RCC_SW_FIFO_FLUSH		OS_IOCTL_RW(226,  4, s32)
#define	SIO4_IOCTL_RCC_SW_FIFO_READ			OS_IOCTL_RW(227,  4, s32)
#define SIO4_IOCTL_RX_FIFO_FULL_CFG_GLB		OS_IOCTL_RW(228,  4, s32)



//*****************************************************************************
// Register definition utility macros
#define SIO4_GSC_ENCODE(t,f,m,s,o)			SIO4_REG_ENCODE((t),1,(f),(m),(s),(o))
#define SIO4_USC_ENCODE(s,o)				SIO4_REG_ENCODE(GSC_REG_ALT,0,0,0,(s),(o))

#define SIO4_REG_ENCODE(t,fw,fmt,m,s,o)		(GSC_REG_ENCODE((t),(s),(o))\
											| SIO4_CH_MULT_ENCODE((m))	\
											| SIO4_FORMAT_ENCODE((fmt))	\
											| SIO4_FIRMWARE_ENCODE((fw)))

#define SIO4_CH_MULT_ENCODE(m)				GSC_FIELD_ENCODE((m)/4,20,17)
#define SIO4_FORMAT_ENCODE(fmt)				GSC_FIELD_ENCODE((fmt),24,21)
#define SIO4_FIRMWARE_ENCODE(fw)			GSC_FIELD_ENCODE((fw), 16,16)

#define SIO4_CH_MULT_DECODE(v)				(GSC_FIELD_DECODE((v),20,17)*4)
#define SIO4_FORMAT_DECODE(v)				GSC_FIELD_DECODE((v), 24,21)
#define SIO4_FIRMWARE_DECODE(v)				GSC_FIELD_DECODE((v), 16,16)



//*****************************************************************************
// SIO4_IOCTL_REG_READ
// SIO4_IOCTL_REG_WRITE
// SIO4_IOCTL_REG_MOD
//
// Parameter:	gsc_reg_t*
//		Please note that not all registers are present on all boards.

#define SIO4_GSC_FRR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0x00)// Firmware Rev Reg
#define SIO4_GSC_BCR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0x04)// Board Control Reg
#define SIO4_GSC_BSR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0x08)// Board Status Reg
#define SIO4_GSC_CCR	SIO4_GSC_ENCODE(GSC_REG_ALT,1, 0,4,0x0C)// Clock Control Reg
#define SIO4_GSC_TSR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0x0C)// Time Stamp Register

#define SIO4_GSC_TAR	SIO4_GSC_ENCODE(GSC_REG_ALT,0,16,4,0x10)// Tx Almost Reg
#define SIO4_GSC_RAR	SIO4_GSC_ENCODE(GSC_REG_ALT,0,16,4,0x14)// Rx Almost Reg
#define SIO4_GSC_FDR	SIO4_GSC_ENCODE(GSC_REG_ALT,0,16,4,0x18)// FIFO Data Reg
#define SIO4_GSC_CSR	SIO4_GSC_ENCODE(GSC_REG_ALT,0,16,4,0x1C)// Control/Status Reg

#define SIO4_GSC_SBR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0x50)// Sync Byte Register

#define SIO4_GSC_ICR	SIO4_GSC_ENCODE(GSC_REG_ALT,2, 0,4,0x60)// Interrupt Control
#define SIO4_GSC_ISR	SIO4_GSC_ENCODE(GSC_REG_ALT,2, 0,4,0x64)// Interrupt Status
#define SIO4_GSC_IELR	SIO4_GSC_ENCODE(GSC_REG_ALT,2, 0,4,0x68)// Int Edge/Level Reg
#define SIO4_GSC_IHLR	SIO4_GSC_ENCODE(GSC_REG_ALT,2, 0,4,0x6C)// Int Hi/Low Reg

#define SIO4_GSC_PSRCR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0x80)// Pin Source Reg
#define SIO4_GSC_PSTSR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0x90)// Pin Ststus Reg
#define SIO4_GSC_GPIOSR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0x90)// GPIO Source Register
#define SIO4_GSC_IOCR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0x90)// I/O Control Register

#define SIO4_GSC_FCR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0xD0)// FIFO Count Reg
#define SIO4_GSC_FSR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0xE0)// FIFO Size Reg
#define SIO4_GSC_FTR	SIO4_GSC_ENCODE(GSC_REG_ALT,3, 0,4,0xF8)// Firmware Type Register
#define SIO4_GSC_FR		SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0xFC)// Features Register

// For SYNC boards only.
#define SIO4_GSC_TCR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0xB0)// Tx Count Reg
#define SIO4_GSC_RCR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0xC0)// Rx Count Reg

// CY22393 oscillator programming
#define SIO4_GSC_PORAR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0xA0)// Prog Osc RAM Adrs
#define SIO4_GSC_PORDR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0xA4)// Prog Osc RAM Data
#define SIO4_GSC_POCSR	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0xA8)// Prog Osc Ctrl/Stat
#define SIO4_GSC_PORD2R	SIO4_GSC_ENCODE(GSC_REG_GSC,0, 0,4,0xAC)// Prog Osc RAM Data 2

// IDC2053B oscillator programming
#define SIO4_GSC_PCR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0xA0)// Prog Clock Reg
#define	SIO4_GSC_PCDR	SIO4_GSC_ENCODE(GSC_REG_ALT,0, 4,4,0xA0)// Prog Clock Reg

// USC Registers
#define SIO4_USC_CCAR	SIO4_USC_ENCODE(2, 0)	// Channel Command/Address Register
#define SIO4_USC_CMR	SIO4_USC_ENCODE(2, 2)	// Channel Mode Register
#define SIO4_USC_CCSR	SIO4_USC_ENCODE(2, 4)	// Channel Command/Status Register
#define SIO4_USC_CCR	SIO4_USC_ENCODE(2, 6)	// Channel Control Register
#define SIO4_USC_PRR	SIO4_USC_ENCODE(2, 8)	// Primary Reserved Register
#define SIO4_USC_SRR	SIO4_USC_ENCODE(2,10)	// Secondary Reserved Register
#define SIO4_USC_TMDR	SIO4_USC_ENCODE(2,12)	// Test Mode Data Register
#define SIO4_USC_TMCR	SIO4_USC_ENCODE(2,14)	// Test Mode Control Register
#define SIO4_USC_CMCR	SIO4_USC_ENCODE(2,16)	// Clock Mode Control Register
#define SIO4_USC_HCR	SIO4_USC_ENCODE(2,18)	// Hardware Configuration Register
#define SIO4_USC_IVR	SIO4_USC_ENCODE(2,20)	// Interrupt Vector Register
#define SIO4_USC_IOCR	SIO4_USC_ENCODE(2,22)	// I/O Control Register
#define SIO4_USC_ICR	SIO4_USC_ENCODE(2,24)	// Interrupt Control Register
#define SIO4_USC_DCCR	SIO4_USC_ENCODE(2,26)	// Daisy-Chain Control Register
#define SIO4_USC_MISR	SIO4_USC_ENCODE(2,28)	// Miscellaneous Interrupt Status Register
#define SIO4_USC_SICR	SIO4_USC_ENCODE(2,30)	// Status Interrupt Control Register
#define SIO4_USC_RDR	SIO4_USC_ENCODE(2,32)	// Receive Data Register
#define SIO4_USC_RMR	SIO4_USC_ENCODE(2,34)	// Receive Mode Register
#define SIO4_USC_RCSR	SIO4_USC_ENCODE(2,36)	// Receive Command Status Register
#define SIO4_USC_RICR	SIO4_USC_ENCODE(2,38)	// Receive Interrupt Control Register
#define SIO4_USC_RSR	SIO4_USC_ENCODE(2,40)	// Receive Sync Register
#define SIO4_USC_RCLR	SIO4_USC_ENCODE(2,42)	// Receive Count Limit Register
#define SIO4_USC_RCCR	SIO4_USC_ENCODE(2,44)	// Receive Character Count Register
#define SIO4_USC_TC0R	SIO4_USC_ENCODE(2,46)	// Time Constant 0 Register
#define SIO4_USC_TDR	SIO4_USC_ENCODE(2,48)	// Transmit Data Register
#define SIO4_USC_TMR	SIO4_USC_ENCODE(2,50)	// Transmit Mode Register
#define SIO4_USC_TCSR	SIO4_USC_ENCODE(2,52)	// Transmit Command/Status Register
#define SIO4_USC_TICR	SIO4_USC_ENCODE(2,54)	// Transmit Interrupt Control Register
#define SIO4_USC_TSR	SIO4_USC_ENCODE(2,56)	// Transmit Sync Register
#define SIO4_USC_TCLR	SIO4_USC_ENCODE(2,58)	// Transmit Count Limit Register
#define SIO4_USC_TCCR	SIO4_USC_ENCODE(2,60)	// Transmit Character Count Register
#define SIO4_USC_TC1R	SIO4_USC_ENCODE(2,62)	// Time Constant 1 Register

//*****************************************************************************
// SIO4_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		Pass in -1 for support information; zero is returned.
//		The value returned is the answer to the query.
//		The value -1 is returned if the feature is not supported.

typedef enum
{
	SIO4_QUERY_COUNT,				// First: The number of query options.
	SIO4_QUERY_BOARD_RESET,			// BCR D31: Board Reset?
	SIO4_QUERY_BUS_SPEED,			// 33 or 66 (MHz)
	SIO4_QUERY_BUS_WIDTH,			// 32 or 64 (bits)
	SIO4_QUERY_CHANNEL_QTY,			// For the entire board.
	SIO4_QUERY_DEVICE_QTY,			// SIO4 = 1, SIO8 = 2
	SIO4_QUERY_DEVICE_TYPE,			// gsc_dev_type_t
	SIO4_QUERY_DMDMA_SCD,			// BCR D3/D7: DMDMA Single Cycle Disable?
	SIO4_QUERY_FIFO_SIZE_RX,		// Rx FIFO Size: bytes (FSR D16-D31)
	SIO4_QUERY_FIFO_SIZE_TOTAL,		// Total FIFOs on board: bytes
	SIO4_QUERY_FIFO_SIZE_TX,		// Tx FIFO Size: bytes (FSR D0-D15)
	SIO4_QUERY_FIFO_SPACE_CFG,		// FIFO Space Reconfiguration?
	SIO4_QUERY_FORM_FACTOR,			// sio4_form_factor_t
	SIO4_QUERY_FW_TYPE,				// sio4_fw_type_t
	SIO4_QUERY_INDEX_CHANNEL,		// 0-3
	SIO4_QUERY_INDEX_DEVICE,		// /dev/sio4X: 0, 1, 2, 3, 4, 5 ...
	SIO4_QUERY_INDEX_SUBDEVICE,		// SIO4: 0, SIO8: 0, 1
	SIO4_QUERY_IRQ_32,				// Is the ICR 32 bits? If no, then 16.
	SIO4_QUERY_LED_CHANNEL,			// How many channel LEDs are there?
	SIO4_QUERY_LED_MAIN,			// How many main LEDs are there?
	SIO4_QUERY_LEGACY_CABLE,		// Legacy Cable Control: Supported?
	SIO4_QUERY_MODEL_BASE,			// sio4_model_t
	SIO4_QUERY_MODEL_SYNC,			// Is this a SYNC model board?
	SIO4_QUERY_MODEL_Z16C30,		// Is this a Z16C30 model board?
	SIO4_QUERY_MP,					// Multi-Protocol Transceiver support?
	SIO4_QUERY_MP_BITMAP,			// Supported Valid MP protocols
	SIO4_QUERY_MP_CHIP,				// Multi-Protocol Transceiver chip?
	SIO4_QUERY_MP_PROGRAM,			// Multi-Protocol Transceiver programmable?
	SIO4_QUERY_OSC_CHIP,			// sio4_osc_chip_t
	SIO4_QUERY_OSC_MEASURE,			// Can the osc rate be measured?
	SIO4_QUERY_OSC_PD_MAX,			// Maximum Post Divider value.
	SIO4_QUERY_OSC_PER_CHANNEL,		// Is there an osc output per channel?
	SIO4_QUERY_OSC_PROGRAM,			// Is the oscillator programmable?
	SIO4_QUERY_REG_BSR,				// Board Status Register: Supported?
	SIO4_QUERY_REG_CCR,				// Clock Control Register: Supported?
	SIO4_QUERY_REG_FCR,				// FIFO Count Registers: Supported?
	SIO4_QUERY_REG_FR,				// Features Register: Supported?
	SIO4_QUERY_REG_FSR,				// FIFO Size Registers: Supported?
	SIO4_QUERY_REG_FTR,				// Firmware Type Register: Supported
	SIO4_QUERY_REG_GPIOSR,			// GPIO Source Register: Supported?
	SIO4_QUERY_REG_IELR,			// IRQ Edge/Level Register: Supported?
	SIO4_QUERY_REG_IHLR,			// IRQ High/Low Register: Supported?
	SIO4_QUERY_REG_IOCR,			// I/O Control Register: Supported?
	SIO4_QUERY_REG_PCR,				// Prog Clock Register: Supported?
	SIO4_QUERY_REG_POCSR,			// Prog Osc Control/Status Reg: Supported?
	SIO4_QUERY_REG_PORAR,			// Prog Osc RAM Adrs Reg: Supported?
	SIO4_QUERY_REG_PORDR,			// Prog Osc RAM Data Reg: Supported?
	SIO4_QUERY_REG_PORD2R,			// Prog Osc RAM Data 2 Reg: Supported?
	SIO4_QUERY_REG_PSRCR,			// Pin Source Register: Supported?
	SIO4_QUERY_REG_PSRCR_BITS,		// Supported PSRCR bits.
	SIO4_QUERY_REG_PSTSR,			// Pin Status Register: Supported?
	SIO4_QUERY_REG_PSTSR_BITS,		// Supported PSTSR bits.
	SIO4_QUERY_REG_RCR,				// Rx Count Register: Supported?
	SIO4_QUERY_REG_SBR,				// Sync Byte Register: Supported?
	SIO4_QUERY_REG_TCR,				// Tx Count Register: Supported?
	SIO4_QUERY_REG_TSR,				// Time Stamp Register: Supported?
	SIO4_QUERY_RX_FIFO_FULL_CFG,	// CSR D19: Rx FIFO Stop On Full? CHANNEL SPECIFIC
	SIO4_QUERY_RX_FIFO_OVERRUN,		// Rx FIFO Overrun supported?
	SIO4_QUERY_RX_FIFO_UNDERRUN,	// Rx FIFO Underrun supported?
	SIO4_QUERY_RX_STATUS_WORD,		// CSR D3: Rx Status Word Enable?
	SIO4_QUERY_SIO4_TYPE,			// sio4_type_t
	SIO4_QUERY_TIME_STAMP,			// Is the timestamp feature supported?
	SIO4_QUERY_TX_FIFO_EMPTY_CFG,	// CSR D18/D26: Tx Disable on FIFO Empty?
	SIO4_QUERY_TX_FIFO_OVERRUN,		// Tx FIFO Overrun supported?
	SIO4_QUERY_USER_JUMPER_QTY,		// >= 0
	SIO4_QUERY_USER_JUMPER_SENSE,	// 1: "1" = on, 0: "0" = on
	SIO4_QUERY_USER_JUMPER_VAL,		// The value shown in the /proc/sio4:ids field.
	SIO4_QUERY_RX_FIFO_FULL_CFG_GLB,// BCR D8: Rx FIFO Stop On Full? GLOBAL
	SIO4_QUERY_INDEX_BOARD,			// Index of each SIO4 (SIO8 counts as two).
	SIO4_QUERY_FW_TYPE_CONFIG,		// Is the FW Type configurable?
	SIO4_IOCTL_QUERY_LAST			// MUST BE LAST!
} sio4_query_t;

// SIO4_QUERY_FORM_FACTOR
typedef enum
{
	SIO4_FORM_FACTOR_PCI		= 1,
	SIO4_FORM_FACTOR_PMC		= 2,
	SIO4_FORM_FACTOR_CPCI		= 3,
	SIO4_FORM_FACTOR_PC104P		= 4,
	SIO4_FORM_FACTOR_PCIE		= 5,
	SIO4_FORM_FACTOR_XMC		= 6,

	SIO4_FORM_FACTOR_PCI66		= 100,
	SIO4_FORM_FACTOR_PCIE4,
	SIO4_FORM_FACTOR_PMC66,
	SIO4_FORM_FACTOR_UNKNOWN			// must exceed field range
} sio4_form_factor_t;

// SIO4_QUERY_FW_TYPE
typedef enum
{
	SIO4_FW_TYPE_Z16C30		= 0x01,
	SIO4_FW_TYPE_SYNC		= 0x04
} sio4_fw_type_t;

// SIO4_QUERY_MP_CHIP
typedef enum
{
	SIO4_MP_CHIP_FIXED,
	SIO4_MP_CHIP_SP508
} sio4_mp_chip_t;

// SIO4_QUERY_OSC_CHIP
typedef enum
{
	SIO4_OSC_CHIP_FIXED,		// fixed
	SIO4_OSC_CHIP_IDC2053B,		// 1 x IDC2053B
	SIO4_OSC_CHIP_IDC2053B_4,	// 4 x IDC2053B
	SIO4_OSC_CHIP_CY22393,		// 1 x CY22393
	SIO4_OSC_CHIP_CY22393_2		// 2 x CY22393
} sio4_osc_chip_t;

// SIO4_QUERY_SIO4_TYPE
typedef enum
{
	SIO4_TYPE_SIO4,
	SIO4_TYPE_SIO4A,
	SIO4_TYPE_SIO4AR,
	SIO4_TYPE_SIO4AHRM,
	SIO4_TYPE_SIO4B,
	SIO4_TYPE_SIO4BX,
	SIO4_TYPE_SIO4BXR,
	SIO4_TYPE_SIO8BXS,
	SIO4_TYPE_SIO4BX2,
	SIO4_TYPE_SIO8BX2

} sio4_type_t;

// SIO4_QUERY_BASE_MODEL
typedef enum
{
	SIO4_MODEL_SIO4,
	SIO4_MODEL_SIO4A,
	SIO4_MODEL_SIO4A_SYNC,
	SIO4_MODEL_SIO4AR,
	SIO4_MODEL_SIO4AR_SYNC,
	SIO4_MODEL_SIO4AHRM,
	SIO4_MODEL_SIO4AHRM_SYNC,
	SIO4_MODEL_SIO4B,
	SIO4_MODEL_SIO4B_SYNC,
	SIO4_MODEL_SIO4BX,
	SIO4_MODEL_SIO4BX_SYNC,
	SIO4_MODEL_SIO4BXR,
	SIO4_MODEL_SIO4BXR_SYNC,
	SIO4_MODEL_SIO8BXS,
	SIO4_MODEL_SIO8BXS_SYNC,
	SIO4_MODEL_SIO4BX2,
	SIO4_MODEL_SIO4BX2_SYNC,
	SIO4_MODEL_SIO8BX2,
	SIO4_MODEL_SIO8BX2_SYNC

} sio4_model_t;

//*****************************************************************************
// SIO4_IOCTL_INITIALIZE
//
//	Parameter:	s32*
//		Pass in -1 for support status; 1 is returned.
//		Pass in 1 to perform initialization.
//		The value 1 is returned if the initialization was performed.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_CBL_MODE						PSRCR D28
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_CBL_MODE_DTE					0
#define SIO4_CBL_MODE_DCE					1

//*****************************************************************************
// SIO4_IOCTL_CBL_PIN_STATUS				PSTSR D0-?? - field varies per board
//
//	Parameter:	s32*
//		The value -1 is passed in to request the pins status.
//		The value returned is the value read from the Pin Status Register.
//		Unsupported bits are cleared in the value returned.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_FIFO_SPACE_CFG				CSR D4-D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_FIFO_SPACE_CFG_RX_2X			0	// Rx has 2x, Tx has x
#define SIO4_FIFO_SPACE_CFG_TX_2X			1	// Tx has 2x, Rx has x

//*****************************************************************************
// SIO4_IOCTL_GPIO_DIRECTION_OUT			IOCR D0-D5
//
//	Parameter:	s32*
//		Output value from zero to 0x3F,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_GPIO_INPUT_LATCHING			IOCR D8-D13
//
//	Parameter:	s32*
//		Output value from zero to 0x3F,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_GPIO_INPUT_READ				IOCR D16-D21
//
//	Parameter:	s32*
//		The value passed in is -1.
//		The value returned is from zero to 0x3F.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_GPIO_OUTPUT_WRITE				IOCR D8-D13
//
//	Parameter:	s32*
//		Output value from zero to 0x3F,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_GPIO_POLARITY					IOCR D30
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_GPIO_POLARITY_LOW				0
#define SIO4_GPIO_POLARITY_HIGH				1

//*****************************************************************************
// SIO4_IOCTL_GPIO_SENSE_EDGE				IOCR D24-D29
//
//	Parameter:	s32*
//		Output value from zero to 0x3F,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_IRQ_GSC_CFG_HIGH				IHLR D0-D31
// SIO4_IOCTL_IRQ_GSC_ENABLE				ICR D0-D31
//
//	Parameter:	s32*
//		Pass in any combination of the below values,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_IRQ_SYNC_BYTE					0x00000001	// Z16C30
#define SIO4_IRQ_RX_ENV						0x00000001	// SYNC
#define SIO4_IRQ_TX_FIFO_AE					0x00000002
#define SIO4_IRQ_RX_FIFO_AF					0x00000004
#define SIO4_IRQ_USC						0x00000008	// Z16C30
#define SIO4_IRQ_RX_SPARE					0x00000008	// SYNC
#define SIO4_IRQ_TX_FIFO_E					0x00010000
#define SIO4_IRQ_TX_FIFO_F					0x00020000
#define SIO4_IRQ_RX_FIFO_E					0x00040000
#define SIO4_IRQ_RX_FIFO_F					0x00080000
#define SIO4_IRQ_ALL						0x000F000F

//*****************************************************************************
// SIO4_IOCTL_IRQ_USC_ENABLE				USC various registers and fields
//
//	Parameter:	s32*
//		Pass in any combination of the below values,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_IRQ_USC_RX_EXITED_HUNT			0x00000001
#define SIO4_IRQ_USC_RX_IDLE_RECEIVED		0x00000002
#define SIO4_IRQ_USC_RX_BREAK_ABORT			0x00000004
#define SIO4_IRQ_USC_RX_BOUND				0x00000008
#define SIO4_IRQ_USC_RX_ABORT_PAR_ERROR		0x00000010
#define SIO4_IRQ_USC_RX_OVERRUN				0x00000020
#define SIO4_IRQ_USC_RX_DATA				0x00000040
#define SIO4_IRQ_USC_TX_PREAMBLE_SENT		0x00000080
#define SIO4_IRQ_USC_TX_IDLE_SENT			0x00000100
#define SIO4_IRQ_USC_TX_ABORT_SENT			0x00000200
#define SIO4_IRQ_USC_TX_END_SENT			0x00000400
#define SIO4_IRQ_USC_TX_CRC_SENT			0x00000800
#define SIO4_IRQ_USC_TX_UNDERRUN			0x00001000
#define SIO4_IRQ_USC_TX_DATA				0x00002000
#define SIO4_IRQ_USC_IOP_RXC_FALL			0x00004000
#define SIO4_IRQ_USC_IOP_RXC_RISE			0x00008000
#define SIO4_IRQ_USC_IOP_TXC_FALL			0x00010000
#define SIO4_IRQ_USC_IOP_TXC_RISE			0x00020000
#define SIO4_IRQ_USC_IOP_RXREQ_FALL			0x00040000
#define SIO4_IRQ_USC_IOP_RXREQ_RISE			0x00080000
#define SIO4_IRQ_USC_IOP_TXREQ_FALL			0x00100000
#define SIO4_IRQ_USC_IOP_TXREQ_RISE			0x00200000
#define SIO4_IRQ_USC_IOP_DCD_FALL			0x00400000
#define SIO4_IRQ_USC_IOP_DCD_RISE			0x00800000
#define SIO4_IRQ_USC_IOP_CTS_FALL			0x01000000
#define SIO4_IRQ_USC_IOP_CTS_RISE			0x02000000
#define SIO4_IRQ_USC_MISC_RCC_UNDERRUN		0x04000000
#define SIO4_IRQ_USC_MISC_DPLL_DESYNC		0x08000000
#define SIO4_IRQ_USC_MISC_BRG1_ZERO			0x10000000
#define SIO4_IRQ_USC_MISC_BRG0_ZERO			0x20000000
#define SIO4_IRQ_USC_ALL					0x3FFFFFFF

//*****************************************************************************
// SIO4_IOCTL_LED_CHANNEL					CSR	D20-D23
//
//	Parameter:	s32*
//		Pass in a bitmap for the LEDs to turn on or off,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
//		If an LED is disabled, then it is reported as OFF.

//*****************************************************************************
// SIO4_IOCTL_LED_MAIN						BCR D24-D26
//
//	Parameter:	s32*
//		Pass in a bitmap for the LEDs to turn on or off,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
//		If an LED is disabled, then it is reported as OFF.

//*****************************************************************************
// SIO4_IOCTL_LOOP_BACK						PSRCR D23, D29, CSR	D28
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_LOOP_BACK_DISABLE				0x00
#define SIO4_LOOP_BACK_INTERNAL				0x01
#define SIO4_LOOP_BACK_EXTERNAL				0x40

//*****************************************************************************
// SIO4_IOCTL_OSC_MEASURE
//
//	Parameter:	s32*
//		Pass in the value of 1 to perform the measurement, or
//		or -1 to obtain support status.
//		The value returned is the measured oscillator frequency.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_OSC_PROGRAM
//
//	Parameter:	s32*
//		Pass in any value from zero to 20,000,000,
//		or -1 to read the last programmed value.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_OSC_REFERENCE
//
//	Parameter:	s32*
//		Pass in any value from zero to 20,000,000,
//		or -1 to read the last programmed value.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_AE					RAR D0-D15
// SIO4_IOCTL_RX_FIFO_AF					RAR D16-D31
// SIO4_IOCTL_TX_FIFO_AE					TAR D0-D15
// SIO4_IOCTL_TX_FIFO_AF					TAR D16-D31
//
//	Parameter:	s32*
//		Pass in any value in the range from 0 to 0xFFFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_FILL_LEVEL			FCR D16-D31
// SIO4_IOCTL_TX_FIFO_FILL_LEVEL			FCR D0-D15
//
//	Parameter:	s32*
//		Pass in -1 for the fill level.
//		The value returned will be from 0 to 0xFFFF.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_FULL_CFG				CSR D19
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_RX_FIFO_FULL_CFG_OVER			0
#define SIO4_RX_FIFO_FULL_CFG_DISABLE		1

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_FULL_CFG_GLB			BCR D8
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_RX_FIFO_FULL_CFG_GLB_OVER		0	// Defers to channel setting
#define SIO4_RX_FIFO_FULL_CFG_GLB_DISABLE	1	// Overrides channel setting

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_OVERRUN				CSR	D16
// SIO4_IOCTL_TX_FIFO_OVERRUN				CSR	D17
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_FIFO_OVERRUN_CLEAR				1
#define SIO4_FIFO_OVERRUN_TEST				(-1)
// The following values are returned.
#define SIO4_FIFO_OVERRUN_NO				0
#define SIO4_FIFO_OVERRUN_YES				1

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_RESET					CSR	D1
// SIO4_IOCTL_TX_FIFO_RESET					CSR	D0
//
//	Parameter:	s32*
//		Pass in -1 for support status; 1 is returned.
//		Pass in 1 to perform the reset.
//		The value -1 is returned if the feature is not supported.
//		The value 1 is returned if the FIFO was reset.
//		The value 0 is returned if the FIFO was not reset.

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_STATUS				CSR	D12-D15
// SIO4_IOCTL_TX_FIFO_STATUS				CSR	D8-D11
//
//	Parameter:	s32*
//		Pass in -1 for status.
//		The returned value is one of the below options.
//		The value -1 is returned if the feature is not supported.
#define SIO4_FIFO_STATUS_EMPTY				0
#define SIO4_FIFO_STATUS_ALMOST_EMPTY		1
#define SIO4_FIFO_STATUS_MEDIUM				2
#define SIO4_FIFO_STATUS_ALMOST_FULL		3
#define SIO4_FIFO_STATUS_FULL				4

//*****************************************************************************
// SIO4_IOCTL_RX_FIFO_UNDERRUN				CSR D18
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_FIFO_UNDERRUN_CLEAR			1
#define SIO4_FIFO_UNDERRUN_TEST				(-1)
// The following values are returned.
#define SIO4_FIFO_UNDERRUN_NO				0
#define SIO4_FIFO_UNDERRUN_YES				1

//*****************************************************************************
// SIO4_IOCTL_RX_IO_ABORT
// SIO4_IOCTL_TX_IO_ABORT
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define	SIO4_IO_ABORT_NO					0
#define	SIO4_IO_ABORT_YES					1

//*****************************************************************************
// SIO4_IOCTL_RX_IO_MODE
// SIO4_IOCTL_TX_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
// GSC_IO_MODE_PIO
// GSC_IO_MODE_DMA
// GSC_IO_MODE_DMDMA
#define SIO4_IO_MODE_DEFAULT				GSC_IO_MODE_PIO

//*****************************************************************************
// SIO4_IOCTL_RX_IO_OVERRUN
// SIO4_IOCTL_TX_IO_OVERRUN
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define	SIO4_IO_OVERRUN_IGNORE				0
#define	SIO4_IO_OVERRUN_CHECK				1

//*****************************************************************************
// SIO4_IOCTL_RX_IO_PIO_THRESHOLD
// SIO4_IOCTL_TX_IO_PIO_THRESHOLD
//
//	Parameter:	s32*
//		Pass in any value from zero to 0xFFFFFFF, or
//		-1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_IO_PIO_THRESHOLD_DEFAULT		64

//*****************************************************************************
// SIO4_IOCTL_RX_IO_TIMEOUT
// SIO4_IOCTL_TX_IO_TIMEOUT
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_IO_TIMEOUT_DEFAULT				10
#define SIO4_IO_TIMEOUT_NO_SLEEP			0
#define SIO4_IO_TIMEOUT_MIN					0
#define SIO4_IO_TIMEOUT_MAX					3600	// 1 hour

//*****************************************************************************
// SIO4_IOCTL_RX_IO_UNDERRUN
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define	SIO4_IO_UNDERRUN_IGNORE				0
#define	SIO4_IO_UNDERRUN_CHECK				1

//*****************************************************************************
// SIO4_IOCTL_SYNC_LEG_RXD_CFG				CSR D4-D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_LEG_RXD_CFG_TRI			0
#define SIO4_SYNC_LEG_RXD_CFG_UP			1
#define SIO4_SYNC_LEG_RXD_CFG_LOW			2

//*****************************************************************************
// SIO4_IOCTL_SYNC_LEG_TXD_CFG				CSR D2-D3
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_LEG_TXD_CFG_TRI			0
#define SIO4_SYNC_LEG_TXD_CFG_UP			1
#define SIO4_SYNC_LEG_TXD_CFG_LOW			2
#define SIO4_SYNC_LEG_TXD_CFG_UP_LOW		3

//*****************************************************************************
// SIO4_IOCTL_SYNC_MODE						CSR	D29
//
//	Parameter:	s32*
//		One of the below values is returned.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_MODE_NORMAL				0
#define SIO4_SYNC_MODE_DUAL					1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RX_BIT_COUNT				RCR D0-D15
//
//	Parameter:	s32*
//		Pass in -1.
//		The value returned will be from 0 to 0xFFFF.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_SYNC_RX_BIT_ORDER				CSR	D24, D27
// SIO4_IOCTL_SYNC_TX_BIT_ORDER				CSR	D25, D28
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_BIT_ORDER_MSB				0
#define SIO4_SYNC_BIT_ORDER_LSB				1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RXC_POL					CSR	D19
// SIO4_IOCTL_SYNC_TXC_POL					CSR	D20
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_CLOCK_POL_FALL			0
#define SIO4_SYNC_CLOCK_POL_RISE			1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RX_COUNT_ERROR			CSR	D31
//
//	Parameter:	s32*
//		Pass in the value -1.
//		One of the below values is returned.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_RX_COUNT_ERROR_NO			0
#define SIO4_SYNC_RX_COUNT_ERROR_YES		1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RX_COUNT_RESET			CSR	D23, D29
//
//	Parameter:	s32*
//		Pass in the value -1 for support information; 0 = supported.
//		Pass in 1 to request a reset.
//		The value 1 is returned if the count was reset.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_SYNC_RX_ENABLE				CSR	D16, D24
// SIO4_IOCTL_SYNC_TX_ENABLE				CSR	D17, D25
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_ENABLE_NO					0
#define SIO4_SYNC_ENABLE_YES				1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RX_GAP_ENABLE			CSR	D30
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_RX_GAP_ENABLE_NO			0
#define SIO4_SYNC_RX_GAP_ENABLE_YES			1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RXC_CFG					PSRCR D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_RXC_CFG_FALL_EDGE			0
#define SIO4_SYNC_RXC_CFG_RISE_EDGE			1

//*****************************************************************************
// SIO4_IOCTL_SYNC_RXD_CFG					PSRCR D16
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_RXD_CFG_ACTIVE_HI			0	// NRZ
#define SIO4_SYNC_RXD_CFG_ACTIVE_LO			1	// NRZB

//*****************************************************************************
// SIO4_IOCTL_SYNC_RXE_CFG					PSRCR D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_RXE_CFG_ACTIVE_HI			0
#define SIO4_SYNC_RXE_CFG_ACTIVE_LO			1
#define SIO4_SYNC_RXE_CFG_DISABLE			2

//*****************************************************************************
// SIO4_IOCTL_SYNC_RXE_POL					CSR	D26
// SIO4_IOCTL_SYNC_TXE_POL					CSR	D27
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_ENV_POL_ACTIVE_LO			0
#define SIO4_SYNC_ENV_POL_ACTIVE_HI			1

//*****************************************************************************
// SIO4_IOCTL_SYNC_TX_WORD_SIZE				TCR D0-D15
// SIO4_IOCTL_SYNC_TX_GAP_SIZE				TCR D16-D31
//
//	Parameter:	s32*
//		Pass in -1 for the the current setting or status;
//		The value returned will be from 0 to 0xFFFF.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXAUXC_CFG				PSRCR D9-D10
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXAUXC_CFG_TRI			0
#define SIO4_SYNC_TXAUXC_CFG_OSC_HALF		1
#define SIO4_SYNC_TXAUXC_CFG_OUT_0			2
#define SIO4_SYNC_TXAUXC_CFG_OUT_1			3

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXC_CFG					CSR	D22
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXC_CFG_INT				0
#define SIO4_SYNC_TXC_CFG_EXT				1

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXC_IDLE					CSR	D21
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXC_IDLE_YES				0
#define SIO4_SYNC_TXC_IDLE_NO				1

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXC_IDLE_CFG				PSRCR D3, D20
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXC_IDLE_CFG_ACTIVE		0x00000
#define SIO4_SYNC_TXC_IDLE_CFG_IDLE_0		0x00001
#define SIO4_SYNC_TXC_IDLE_CFG_IDLE_1		0x20001

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXC_SRC					PSRCR D0-D2
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXC_SRC_OSC_HALF_RISE		0
#define SIO4_SYNC_TXC_SRC_OSC_HALF_FALL		1
#define SIO4_SYNC_TXC_SRC_EXT_RISE			2
#define SIO4_SYNC_TXC_SRC_EXT_FALL			3
#define SIO4_SYNC_TXC_SRC_0					6
#define SIO4_SYNC_TXC_SRC_1					7

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXD_CFG					PSRCR D6-D8
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXD_CFG_ACTIVE_HI			0	// NRZ
#define SIO4_SYNC_TXD_CFG_ACTIVE_LO			1	// NRZB
#define SIO4_SYNC_TXD_CFG_OUT_0				6
#define SIO4_SYNC_TXD_CFG_OUT_1				7

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXD_IDLE_CFG				PSRCR D19
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXD_IDLE_CFG_OUT_0		0
#define SIO4_SYNC_TXD_IDLE_CFG_OUT_1		1

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXE_CFG					PSRCR D4-D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXE_CFG_ACTIVE_HI			0
#define SIO4_SYNC_TXE_CFG_ACTIVE_LO			1
#define SIO4_SYNC_TXE_CFG_OUT_0				2
#define SIO4_SYNC_TXE_CFG_OUT_1				3

//*****************************************************************************
// SIO4_IOCTL_SYNC_TXSP_CFG					PSRCR D11-D12
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_SYNC_TXSP_CFG_DISABLE			0
#define SIO4_SYNC_TXSP_CFG_INPUT			1
#define SIO4_SYNC_TXSP_CFG_OUT_0			2
#define SIO4_SYNC_TXSP_CFG_OUT_1			3

//*****************************************************************************
// SIO4_IOCTL_TIME_STAMP_COUNT				BCR D23
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_TIME_STAMP_COUNT_CONTINUE		0
#define SIO4_TIME_STAMP_COUNT_CLEAR			1

//*****************************************************************************
// SIO4_IOCTL_TIME_STAMP_ENABLE				CSR D2
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_TIME_STAMP_ENABLE_NO			0
#define SIO4_TIME_STAMP_ENABLE_YES			1

//*****************************************************************************
// SIO4_IOCTL_TIME_STAMP_SRC				BCR D22
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_TIME_STAMP_SRC_INT				0
#define SIO4_TIME_STAMP_SRC_EXT				1

//*****************************************************************************
// SIO4_IOCTL_TIME_STAMP_VAL				TSR D0-D23
//
//	Parameter:	s32*
//		Pass in any value in the range from 0 to 0xFFFFFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_TX_FIFO_EMPTY_CFG				CSR D18, D26
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_TX_FIFO_EMPTY_CFG_IGNORE		0	// do nothing
#define SIO4_TX_FIFO_EMPTY_CFG_TX_OFF		1	// Tx Disable

//*****************************************************************************
// SIO4_IOCTL_XCVR_ENABLE					PSRCR D31
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_XCVR_ENABLE_NO					0
#define SIO4_XCVR_ENABLE_YES				1

//*****************************************************************************
// SIO4_IOCTL_XCVR_PROTOCOL					PSRCR D24-D27
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_XCVR_PROTOCOL_RS232			0x0001
#define SIO4_XCVR_PROTOCOL_RS422_RS485		0x0002
#define SIO4_XCVR_PROTOCOL_RS423			0x0004
#define SIO4_XCVR_PROTOCOL_RS422_RS423_1	0x0008	// RS-422/RS-423 Mixed Mode 1
#define SIO4_XCVR_PROTOCOL_RS422_RS423_2	0x0010	// RS-422/RS-423 Mixed Mode 2
#define SIO4_XCVR_PROTOCOL_RS530			0x0020	// RS-530 Mode 1
#define SIO4_XCVR_PROTOCOL_RS530A			0x0040	// RS-530 Mode 2
#define SIO4_XCVR_PROTOCOL_V35				0x0080	// V.35 Mode 1
#define SIO4_XCVR_PROTOCOL_V35A				0x0100	// V.35 Mode 2
#define	SIO4_XCVR_PROTOCOL_DISABLE			0		// Hi Impediance
#define	SIO4_XCVR_PROTOCOL_INVALID			(-2)
#define	SIO4_XCVR_PROTOCOL_UNKNOWN			(-3)

//*****************************************************************************
// SIO4_IOCTL_XCVR_TERM						PSRCR D30
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_XCVR_TERM_ENABLE				0
#define SIO4_XCVR_TERM_DISABLE				1

//*****************************************************************************
// SIO4_IOCTL_Z16_CBL_DCD_CFG				PSRCR D15-D16
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_CBL_DCD_CFG_OUT_USC_DCD	0
#define SIO4_Z16_CBL_DCD_CFG_OUT_RTS		1	// Rx FIFO Almost Full
#define SIO4_Z16_CBL_DCD_CFG_OUT_0			2
#define SIO4_Z16_CBL_DCD_CFG_OUT_1			3

//*****************************************************************************
// SIO4_IOCTL_Z16_CBL_DTR_DSR_CFG			PSRCR D21-D22
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_CBL_DTR_DSR_CFG_TRI		0
#define SIO4_Z16_CBL_DTR_DSR_CFG_IN			1	// DSR
#define SIO4_Z16_CBL_DTR_DSR_CFG_OUT_0		2
#define SIO4_Z16_CBL_DTR_DSR_CFG_OUT_1		3

//*****************************************************************************
// SIO4_IOCTL_Z16_CBL_RTS_CFG				PSRCR D13-D14
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_CBL_RTS_CFG_OUT_USC_CTS	0
#define SIO4_Z16_CBL_RTS_CFG_OUT_RTS		1	// Rx FIFO Almost Full
#define SIO4_Z16_CBL_RTS_CFG_OUT_0			2
#define SIO4_Z16_CBL_RTS_CFG_OUT_1			3

//*****************************************************************************
// SIO4_IOCTL_Z16_CBL_TXAUXC_CFG			PSRCR D17-D18
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_CBL_TXAUXC_CFG_TRI			0
#define SIO4_Z16_CBL_TXAUXC_CFG_OUT_OSC		1
#define SIO4_Z16_CBL_TXAUXC_CFG_OUT_0		2
#define SIO4_Z16_CBL_TXAUXC_CFG_OUT_1		3

//*****************************************************************************
// SIO4_IOCTL_Z16_CBL_TXC_CFG				PSRCR D6-D8
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_CBL_TXC_CFG_OUT_OSC		0
#define SIO4_Z16_CBL_TXC_CFG_OUT_OSC_INV	1
#define SIO4_Z16_CBL_TXC_CFG_OUT_0			2
#define SIO4_Z16_CBL_TXC_CFG_OUT_1			3
#define SIO4_Z16_CBL_TXC_CFG_OUT_USC_TXC	4
#define SIO4_Z16_CBL_TXC_CFG_OUT_USC_RXC	5
#define SIO4_Z16_CBL_TXC_CFG_OUT_CBL_RXC	6
#define SIO4_Z16_CBL_TXC_CFG_OUT_CBL_RXA	7

//*****************************************************************************
// SIO4_IOCTL_Z16_CBL_TXD_CFG				PSRCR D19-D20
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_CBL_TXD_CFG_OUT_USC_TXD	0
#define SIO4_Z16_CBL_TXD_CFG_OUT_0			2
#define SIO4_Z16_CBL_TXD_CFG_OUT_1			3

//*****************************************************************************
// SIO4_IOCTL_Z16_LEG_RXC					CCR D2-D3, D6-D7, D10-D11, D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_LEG_RXC_DISABLE			0
#define SIO4_Z16_LEG_RXC_UPPER				1
#define SIO4_Z16_LEG_RXC_LOWER				2

//*****************************************************************************
// SIO4_IOCTL_Z16_LEG_RXD_DCD_CFG			CSR	D4, D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_LEG_RXD_DCD_CFG_TRI		0
#define SIO4_Z16_LEG_RXD_DCD_CFG_UP			1
#define SIO4_Z16_LEG_RXD_DCD_CFG_LOW		2

//*****************************************************************************
// SIO4_IOCTL_Z16_LEG_TXC					CCR D0-D1, D4-D5, D8-D9, D12-D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_LEG_TXC_DISABLE			0
#define SIO4_Z16_LEG_TXC_UPPER				1
#define SIO4_Z16_LEG_TXC_LOWER				2
#define SIO4_Z16_LEG_TXC_BOTH				3

//*****************************************************************************
// SIO4_IOCTL_Z16_LEG_TXD_CTS_CFG			CSR	D2, D3
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_LEG_TXD_CTS_CFG_TRI		0
#define SIO4_Z16_LEG_TXD_CTS_CFG_UP			1
#define SIO4_Z16_LEG_TXD_CTS_CFG_LOW		2
#define SIO4_Z16_LEG_TXD_CTS_CFG_UP_LOW		3

//*****************************************************************************
// SIO4_IOCTL_Z16_RX_STS_WRD_ENABLE			CSR D3
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_Z16_RX_STS_WRD_ENABLE_NO		0
#define SIO4_Z16_RX_STS_WRD_ENABLE_YES		1

//*****************************************************************************
// SIO4_IOCTL_Z16_SYNC_BYTE					SBR D0-D7
//
//	Parameter:	s32*
//		Pass in any value in the range from 0 to 0xFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_WAIT_EVENT					all fields must be valid
// SIO4_IOCTL_WAIT_CANCEL					fields need not be valid
// SIO4_IOCTL_WAIT_STATUS					fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	SIO4_WAIT_GSC_SYNC_BYTE				0x00000001
#define	SIO4_WAIT_GSC_RX_ENV				0x00000001
#define	SIO4_WAIT_GSC_TX_FIFO_AE			0x00000002
#define	SIO4_WAIT_GSC_RX_FIFO_AF			0x00000004
#define	SIO4_WAIT_GSC_USC					0x00000008
#define	SIO4_WAIT_GSC_RX_SPARE				0x00000008
#define	SIO4_WAIT_GSC_TX_FIFO_E				0x00010000
#define	SIO4_WAIT_GSC_TX_FIFO_F				0x00020000
#define	SIO4_WAIT_GSC_RX_FIFO_E				0x00040000
#define	SIO4_WAIT_GSC_RX_FIFO_F				0x00080000
#define	SIO4_WAIT_GSC_ALL					0x000F000F

// gsc_wait_t.alt flags
#define SIO4_WAIT_USC_RX_EXITED_HUNT		0x00000001
#define SIO4_WAIT_USC_RX_IDLE_RECEIVED		0x00000002
#define SIO4_WAIT_USC_RX_BREAK_ABORT		0x00000004
#define SIO4_WAIT_USC_RX_BOUND				0x00000008
#define SIO4_WAIT_USC_RX_ABORT_PAR_ERROR	0x00000010
#define SIO4_WAIT_USC_RX_OVERRUN			0x00000020
#define SIO4_WAIT_USC_RX_DATA				0x00000040
#define SIO4_WAIT_USC_TX_PREAMBLE_SENT		0x00000080
#define SIO4_WAIT_USC_TX_IDLE_SENT			0x00000100
#define SIO4_WAIT_USC_TX_ABORT_SENT			0x00000200
#define SIO4_WAIT_USC_TX_END_SENT			0x00000400
#define SIO4_WAIT_USC_TX_CRC_SENT			0x00000800
#define SIO4_WAIT_USC_TX_UNDERRUN			0x00001000
#define SIO4_WAIT_USC_TX_DATA				0x00002000
#define SIO4_WAIT_USC_IOP_RXC_FALL			0x00004000
#define SIO4_WAIT_USC_IOP_RXC_RISE			0x00008000
#define SIO4_WAIT_USC_IOP_TXC_FALL			0x00010000
#define SIO4_WAIT_USC_IOP_TXC_RISE			0x00020000
#define SIO4_WAIT_USC_IOP_RXREQ_FALL		0x00040000
#define SIO4_WAIT_USC_IOP_RXREQ_RISE		0x00080000
#define SIO4_WAIT_USC_IOP_TXREQ_FALL		0x00100000
#define SIO4_WAIT_USC_IOP_TXREQ_RISE		0x00200000
#define SIO4_WAIT_USC_IOP_DCD_FALL			0x00400000
#define SIO4_WAIT_USC_IOP_DCD_RISE			0x00800000
#define SIO4_WAIT_USC_IOP_CTS_FALL			0x01000000
#define SIO4_WAIT_USC_IOP_CTS_RISE			0x02000000
#define SIO4_WAIT_USC_MISC_RCC_UNDERRUN		0x04000000
#define SIO4_WAIT_USC_MISC_DPLL_DESYNC		0x08000000
#define SIO4_WAIT_USC_MISC_BRG1_ZERO		0x10000000
#define SIO4_WAIT_USC_MISC_BRG0_ZERO		0x20000000
#define SIO4_WAIT_USC_SPURIOUS				0x40000000
#define	SIO4_WAIT_ALT_ALL					0x7FFFFFFF
// gsc_wait_t.io - see gsc_common.h

//*****************************************************************************
// SIO4_IOCTL_RCC_SW_FIFO_ENABLE
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_RCC_SW_FIFO_ENABLE_NO			0
#define SIO4_RCC_SW_FIFO_ENABLE_YES			1

//*****************************************************************************
// SIO4_IOCTL_RCC_SW_FIFO_FLUSH
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_RCC_SW_FIFO_FLUSH_NO			0
#define SIO4_RCC_SW_FIFO_FLUSH_YES			1

//*****************************************************************************
// SIO4_IOCTL_RCC_SW_FIFO_READ
//
//	Parameter:	s32*
//		Pass in any value in the range from 0 to 0x60000,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
//		The return value is zero if no record is available.
//		The below flags are returned in the upper 16-bits.
#define SIO4_RCC_SW_FIFO_READ_ABORT_PE		0x00010000	// Got Abort or Parity Error
#define SIO4_RCC_SW_FIFO_READ_BREAK_ABRT	0x00020000	// Got Break or Abort.
#define SIO4_RCC_SW_FIFO_READ_DPLL_DESYN	0x00040000	// DPLL lost sync
#define SIO4_RCC_SW_FIFO_READ_FRAME_END		0x00080000	// The size is valid.
#define SIO4_RCC_SW_FIFO_READ_OVER_DATA		0x00100000	// Frame data or record lost.
#define SIO4_RCC_SW_FIFO_READ_OVER_FRAME	0x00200000	// Frame data or record lost.



#endif
