// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/rtx/os_utils.h $
// $Rev: 33967 $
// $Date: 2015-11-05 18:41:22 -0600 (Thu, 05 Nov 2015) $

#ifndef __OS_UTILS_H__
#define __OS_UTILS_H__

// RTX

#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <string.h>

#include "os_common.h"



// #defines *******************************************************************

#define close(fd)				_close((fd))
#define open(name,arg)			_open((name),(arg))

#ifdef UNDER_RTSS
#define	printf					RtPrintf
#endif



// data types *****************************************************************

typedef struct
{
	HANDLE	handle;		// valid if handle is non-zero
	char	name[64];
} os_thread_t;

typedef	struct
{
	HANDLE	handle;		// valid if handle is non-zero
} os_sem_t;

typedef enum
{
	OS_SEM_GET_OK,	// The operation was a success.
	OS_SEM_GET_TO,	// The operation timed out.
	OS_SEM_GET_ER	// There was an error.
} os_sem_get_t;



// prototypes *****************************************************************

int				os_count_boards(const char* base);		// # of boards

int				os_id_driver(const char* base);			// # of errors
void			os_id_host(void);

int				os_sem_create(os_sem_t* sem);
int				os_sem_create_qty(os_sem_t* sem, int cap, int put);
int				os_sem_destroy(os_sem_t* sem);
int				os_sem_lock(os_sem_t* sem);
os_sem_get_t	os_sem_lock_to(os_sem_t* sem, int timeout_ms);
int				os_sem_unlock(os_sem_t* sem);

void			os_sleep_ms(int ms);

int				os_thread_create(os_thread_t* thread, const char* name, int (*func)(void* arg), void* arg);
int				os_thread_destroy(os_thread_t* thread);
size_t			os_time_delta_ms(void);



#endif
