// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_common.h $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#ifndef __OS_COMMON_H__
#define __OS_COMMON_H__

#include <errno.h>
#include <windows.h>


// #defines *******************************************************************

#ifndef	EBADE
#define	EBADE						52
#endif

#ifndef	ERESTARTSYS
#define	ERESTARTSYS					512
#endif

#define	OS_IOCTL_DIR_READ			GSC_FIELD_ENCODE(1,26,25)	// app's view
#define	OS_IOCTL_DIR_WRITE			GSC_FIELD_ENCODE(2,26,25)	// app's view
#define	OS_IOCTL_DIR_DECODE(c)		((c) & (OS_IOCTL_DIR_READ | OS_IOCTL_DIR_WRITE))

#define	OS_IOCTL_TYPE_ENCODE(v)		GSC_FIELD_ENCODE((v), 7, 0)
#define	OS_IOCTL_TYPE_DECODE(c)		GSC_FIELD_DECODE((c), 7, 0)

#define	OS_IOCTL_INDEX_ENCODE(v)	GSC_FIELD_ENCODE((v),15, 8)
#define	OS_IOCTL_INDEX_DECODE(c)	GSC_FIELD_DECODE((c),15, 8)

#define	OS_IOCTL_SIZE_ENCODE(v)		GSC_FIELD_ENCODE((v),24,16)
#define	OS_IOCTL_SIZE_DECODE(c)		GSC_FIELD_DECODE((c),24,16)

#define	OS_IOCTL(i)					( OS_IOCTL_TYPE_ENCODE(GSC_IOCTL)	\
									| OS_IOCTL_INDEX_ENCODE((i)))

#define	OS_IOCTL_R(i,s,t)			( OS_IOCTL_DIR_READ					\
									| OS_IOCTL_TYPE_ENCODE(GSC_IOCTL)	\
									| OS_IOCTL_INDEX_ENCODE((i))		\
									| OS_IOCTL_SIZE_ENCODE(s))

#define	OS_IOCTL_RW(i,s,t)			( OS_IOCTL_DIR_READ					\
									| OS_IOCTL_DIR_WRITE				\
									| OS_IOCTL_TYPE_ENCODE(GSC_IOCTL)	\
									| OS_IOCTL_INDEX_ENCODE((i))		\
									| OS_IOCTL_SIZE_ENCODE(s))

#define	OS_IOCTL_W(i,s,t)			( OS_IOCTL_DIR_WRITE				\
									| OS_IOCTL_TYPE_ENCODE(GSC_IOCTL)	\
									| OS_IOCTL_INDEX_ENCODE((i))		\
									| OS_IOCTL_SIZE_ENCODE(s))

#if defined(GSC_LIB_EXPORTS)
	#define	GSC_DLL_DECLSPEC	__declspec(dllexport)
#else
	#define	GSC_DLL_DECLSPEC	__declspec(dllimport)
#endif



// data types *****************************************************************

typedef INT8	s8;
typedef UINT8	u8;

typedef INT16	s16;
typedef UINT16	u16;

typedef INT32	s32;
typedef UINT32	u32;

typedef INT64	s64;
typedef UINT64	u64;



#endif
