// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/id/main.c $
// $Rev: 33960 $
// $Date: 2015-11-01 15:24:45 -0600 (Sun, 01 Nov 2015) $

#include "main.h"



// #defines *******************************************************************

#define	COLUMN_WIDTH	14



// variables ******************************************************************

static	int	_def_index		= 0;



//*****************************************************************************
static int _parse_args(int argc, char** argv)
{
	char	buf[32];
	char	c;
	int		errs	= 0;
	int		i;
	int		j;
	int		k;

	printf("id - Identify the specified device (Version %s)\n", VERSION);
	printf("USAGE: id index\n");
	printf("  index  The zero based index of the board to access (default is 0).\n");

	gsc_label_level_inc();

	for (i = 0; i < argc; i++)
	{
		sprintf(buf, "Argument %d", i);
		gsc_label(buf);
		printf("%s\n", argv[i]);
	}

	gsc_label_level_dec();

	for (i = 1; i < argc; i++)
	{
		j	= sscanf(argv[i], "%d%c", &k, &c);

		if ((j == 1) && (k >= 0))
		{
			_def_index	= k;
			continue;
		}

		errs	= 1;
		printf("ERROR: invalid board index: %s\n", argv[i]);
		break;
	}

	return(errs);
}



//*****************************************************************************
static void _column_headings(int index)
{
	char	buf[COLUMN_WIDTH + 1];
	int		chan;
	int		i;

	// Print the column titles.
	gsc_label("Operation");

	for (i = 0; i <= 3; i++)
	{
		chan	= (index * 4) + i;
		sprintf(buf, "Channel %i", chan);
		local_label_str(buf);
	}

	printf("\n");

	// Print the column spacers.
	gsc_label("=========");

	for (i = 0; i <= 3; i++)
		local_label_str("=========================");

	printf("\n");
}



//*****************************************************************************
static int _channels_open(int index, int* fd)
{
	int	chan;
	int	errs	= 0;
	int	i;

	gsc_label("Opening Channels");

	for (i = 0; i <= 3; i++)
	{
		chan	= (index * 4) + i;
		fd[i]	= sio4_open(chan);

		if (fd[i] < 0)
		{
			errs++;
			local_label_str("FAIL <---");
		}
		else
		{
			local_label_str("PASS");
		}
	}

	if (errs)
		printf("FAIL <---");

	printf("\n");
	return(errs);
}



//*****************************************************************************
static int _channels_close(int* fd)
{
	int	errs	= 0;
	int	i;
	int	ret;

	gsc_label("Closing Channels");

	for (i = 0; i <= 3; i++)
	{
		if (fd[i] < 0)
		{
			local_label_str("----");
			continue;
		}

		ret	= sio4_close(fd[i]);

		if (ret < 0)
		{
			errs++;
			local_label_str("FAIL <---");
		}
		else
		{
			local_label_str("PASS");
		}
	}

	if (errs)
		printf("FAIL <---");

	printf("\n");
	return(errs);
}



//*****************************************************************************
static int _id_model(int index)
{
	char		buf[64];
	int			errs	= 0;
	int			fd;
	const char*	psz		= NULL;

	gsc_label("Board Model");
	index	= index * 4;
	fd		= sio4_open(index);
	errs	+= (fd < 0) ? 1 : 0;

	if (fd >= 0)
	{
		errs	+= sio4_id_form_factor(fd, &psz, 1);
		strcpy(buf, psz);

		errs	+= sio4_id_model(fd, &psz);
		strcat(buf, psz);

		errs	+= sio4_id_fifo_size_total(fd, 1, &psz);
		strcat(buf, psz);
		printf("%s\n", errs ? "" : buf);
		sio4_close(fd);
	}
	else
	{
		printf("FAIL <---  (Board open failure.)\n");
	}

	return(errs ? 1 : 0);
}



/******************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall operation of the application.
*
*	Arguments:
*
*		argc	The number of command line arguments.
*
*		argv	The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	No errors were encounterred.
*		EXIT_FAILURE	One or more errors were encounterred.
*
******************************************************************************/

int main(int argc, char** argv)
{
	int			errs		= 0;
	time_t		exec		= time(NULL);
	long		failures	= 0;
	int			fd[4];
	long		hours;
	long		mins;
	time_t		now;
	long		passes		= 0;
	const char*	psz;
	int			qty			= 0;
	int			ret			= EXIT_SUCCESS;
	long		secs;
	struct tm*	stm;
	time_t		test;
	long		tests		= 0;
	time_t		tt;

	for (;;)
	{
		gsc_label_init(26);
		test	= time(NULL);
		errs	+= _parse_args(argc, argv);

		if (errs)
			break;

		os_id_host();
		errs	+= os_id_driver(SIO4_BASE_NAME);

		if (errs)
			break;

		qty	= os_count_boards(SIO4_BASE_NAME);

		if (qty <= 0)
			break;

		gsc_label("Testing Board Index");
		printf("%d\n", _def_index);

		time(&tt);
		stm	= localtime(&tt);
		psz	= (char*) asctime(stm);
		gsc_label("Performing Test");
		printf("%s", psz);

		errs	+= _id_model(_def_index);

		printf("\n");
		_column_headings(_def_index);
		errs	+= _channels_open(_def_index, fd);

		if ((fd[0] >= 0) ||
			(fd[1] >= 0) ||
			(fd[2] >= 0) ||
			(fd[3] >= 0))
		{
			errs	+= id_device(fd);
			errs	+= _channels_close(fd);
		}

		now		= time(NULL);
		tests++;

		if (errs)
		{
			failures++;
			printf(	"\nRESULTS: FAIL <---  (%d error%s)",
					errs,
					(errs == 1) ? "" : "s");
		}
		else
		{
			passes++;
			printf("\nRESULTS: PASS");
		}

		secs	= (long) (now - test);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(" (duration %ld:%ld:%02ld)\n", hours, mins, secs);

		secs	= (long) (now - exec);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(	"SUMMARY: tests %ld, pass %ld, fail %ld"
				" (duration %ld:%ld:%02ld)\n\n",
				tests,
				passes,
				failures,
				hours,
				mins,
				secs);
		break;
	}

	if ((qty <= 0) || (errs) || (failures))
		ret	= EXIT_FAILURE;

	return(ret);
}



//*****************************************************************************
void local_label_str(const char* str)
{
	char	buf[COLUMN_WIDTH + 1];
	int		len;

	memset(buf, ' ', sizeof(buf));

	if (str == NULL)
		str	= "";

	len	= strlen(str);

	if (len > COLUMN_WIDTH)
		len	= COLUMN_WIDTH;

	strncpy(buf, str, len);
	buf[COLUMN_WIDTH]		= 0;
	buf[COLUMN_WIDTH - 1]	= ' ';
	buf[COLUMN_WIDTH - 2]	= ' ';
	printf("%s", buf);
}


