// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/utils/hdlc_util_tx_flush.c $
// $Rev: 33929 $
// $Date: 2015-10-07 15:08:49 -0500 (Wed, 07 Oct 2015) $

#include "sio4_hdlc_utils.h"



//*****************************************************************************
int hdlc_util_tx_flush(int fd, int index, int verbose, int timeout)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("HDLC Tx Flush", index);

	ret		= sio4_hdlc_tx_flush(fd, timeout);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
	{
	}
	else if (errs)
	{
		printf(	"FAIL <---  (%d second%s, sio4_hdlc_tx_flush)\n",
				timeout,
				(timeout == 1) ? "" : "s");
	}
	else
	{
		printf(	"PASS  (%d second%s)\n",
				timeout,
				(timeout == 1) ? "" : "s");
	}

	return(errs);
}


