// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/version.c $
// $Rev: 23647 $
// $Date: 2013-10-22 11:37:39 -0500 (Tue, 22 Oct 2013) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_hdlc_version
*
*	Purpose:
*
*		Report the library version number to the caller. The version number
*		is given as an integer with the form major * 100 + minor.
*
*	Arguments:
*
*		version	The version number is recorded here.
*
*		built	The build date and time is recorded here.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_hdlc_version(const char** version, const char** built)
{
	static const char*	bld	= __DATE__ ", " __TIME__;
	static const char*	ver	= SIO4_HDLC_LIB_VER;

	int	ret;

	// Make sure the library is initialized.
	ret	= sio4_hdlc_lib_init();

	// Retrieve the verion information.

	if (version)
		version[0]	= ver;

	if (built)
		built[0]	= bld;

	return(ret);
}



