// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/usc_tx_txc_legacy.c $
// $Rev: 23019 $
// $Date: 2013-08-27 14:49:19 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC TxC (Legacy)");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_IN:

			ptr	= "Input";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_CLK:

			ptr	= "Output the Tx Clock";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_BYTE_CLK:

			ptr	= "Output the Tx Byte Clock";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_COMP:

			ptr	= "Output the Tx Complete Signal";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_BRG0:

			ptr	= "Output the BRG0 Output";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_BRG1:

			ptr	= "Output the BRG1 Output";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_CTR1:

			ptr	= "Output the CTR1 Output";
			break;

		case SIO4_HDLC_USC_TX_TXC_LEG_OUT_DPLL_TX:

			ptr	= "Output the DPLL's Tx Clock";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_hdlc_t_usc_tx_txc_legacy(
	int					fd,
	s32*				arg,
	sio4_hdlc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "hdlc->usc.tx.txc_legacy"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_HDLC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_txc_leg(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_HDLC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_HDLC_USC_TX_TXC_LEG_IN;
				break;

		case SIO4_HDLC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_txc_leg(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_HDLC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_HDLC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:				errs	= 1;		break;
					case -1:
					case SIO4_HDLC_USC_TX_TXC_LEG_IN:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_CLK:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_BYTE_CLK:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_COMP:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_BRG0:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_BRG1:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_CTR1:
					case SIO4_HDLC_USC_TX_TXC_LEG_OUT_DPLL_TX:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


