// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/usc_cfg_txc_ctr0_brg0_txclk.c $
// $Rev: 25475 $
// $Date: 2014-02-26 14:57:53 -0600 (Wed, 26 Feb 2014) $

#include "main.h"



//*****************************************************************************
void cfg_txc_ctr0_brg0_txclk(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	typedef struct
	{
		int		use;			//							yes, no
		s32		divide;			//							32, 16, 8, 4, 1
		s32		rate;			// hdlc->usc.ctr0.rate		32, 16, 8, 4, 1
		s32		clk_src;		// hdlc->usc.ctr0.clk_src	TxC, disable
	}  ctr0_t;

	//										use	divide	rate							clk_src
	static const ctr0_t	ctr0_32			= { 1,	32,		SIO4_HDLC_USC_CTR0_RATE_32X,	SIO4_HDLC_USC_CTR0_CLK_SRC_TXC_PIN	};
	static const ctr0_t	ctr0_16			= { 1,	16,		SIO4_HDLC_USC_CTR0_RATE_16X,	SIO4_HDLC_USC_CTR0_CLK_SRC_TXC_PIN	};
	static const ctr0_t	ctr0_8			= { 1,	8,		SIO4_HDLC_USC_CTR0_RATE_8X,		SIO4_HDLC_USC_CTR0_CLK_SRC_TXC_PIN	};
	static const ctr0_t	ctr0_4			= { 1,	4,		SIO4_HDLC_USC_CTR0_RATE_4X,		SIO4_HDLC_USC_CTR0_CLK_SRC_TXC_PIN	};
	static const ctr0_t	ctr0_dis		= { 0,	0,		SIO4_HDLC_USC_CTR0_RATE_32X,	SIO4_HDLC_USC_CTR0_CLK_SRC_DISABLE	};

	typedef struct
	{
		s32			use;		//							yes, no
		s32			enable;		// hdlc->usc.brg0.enable	yes, no
		s32			clk_src;	// hdlc->usc.brg0.clk_src	CTR0, TxC
	} brg0_t;

	//										use	enable							clk_src
	static const brg0_t	brg0_ctr0		= { 1,	SIO4_HDLC_USC_BRG0_ENABLE_YES,	SIO4_HDLC_USC_BRG0_CLK_SRC_CTR0		};
	static const brg0_t	brg0_txc		= { 1,	SIO4_HDLC_USC_BRG0_ENABLE_YES,	SIO4_HDLC_USC_BRG0_CLK_SRC_TXC_PIN	};
	static const brg0_t	brg0_dis		= { 0,	SIO4_HDLC_USC_BRG0_ENABLE_NO,	SIO4_HDLC_USC_BRG0_CLK_SRC_CTR0		};

	typedef struct
	{
		s32			clk_src;	// hdlc->usc.tx.clk_src		BRG0, TxC
	} txclk_t;

	//										clk_src
	static const txclk_t	txclk_brg0		= { SIO4_HDLC_USC_TX_CLK_SRC_BRG0		};
	static const txclk_t	txclk_ctr0		= { SIO4_HDLC_USC_TX_CLK_SRC_CTR0		};
	static const txclk_t	txclk_txc		= { SIO4_HDLC_USC_TX_CLK_SRC_TXC_PIN	};

	static const struct
	{
		const txclk_t*	txclk;
		const brg0_t*	brg0;
		const ctr0_t*	ctr0;
	} data[]	=
	{	// txclk		brg0		ctr0
		{ &txclk_txc,	&brg0_dis,	&ctr0_dis	},

		{ &txclk_ctr0,	&brg0_dis,	&ctr0_32	},
		{ &txclk_ctr0,	&brg0_dis,	&ctr0_16	},
		{ &txclk_ctr0,	&brg0_dis,	&ctr0_8		},
		{ &txclk_ctr0,	&brg0_dis,	&ctr0_4		},

		{ &txclk_brg0,	&brg0_txc,	&ctr0_dis	},

		{ &txclk_brg0,	&brg0_ctr0,	&ctr0_32	},
		{ &txclk_brg0,	&brg0_ctr0,	&ctr0_16	},
		{ &txclk_brg0,	&brg0_ctr0,	&ctr0_8		},
		{ &txclk_brg0,	&brg0_ctr0,	&ctr0_4		}
	};

	float	delta;
	float	delta_best	= 0;
	s32		divide;
	int		i;
	int		j;
	int		max;
	int		min;
	float	rate;
	s32		tc0;
	float	test;
	int		tested		= 0;

	for (i = 0; i < (int) ARRAY_ELEMENTS(data); i++)
	{
		rate	= (float) hdlc->osc.prog;

		if (data[i].ctr0->use)
			rate	/= data[i].ctr0->divide;

		if (data[i].brg0->use)
		{
			divide	= (s32) (rate / bit_rate);
			min		= divide - 1;
			max		= divide + 1;
		}
		else
		{
			min	= 1;
			max	= 1;
		}

		for (j = min; j <= max; j++)
		{
			if (data[i].brg0->use == 0)
				tc0	= 1;
			else if (j < 2)
				tc0	= 2;
			else if (j > 0x10000)
				tc0	= 0x10000;
			else
				tc0	= j;

			test	= rate / tc0;
			delta	= test - bit_rate;
			delta	= (delta < 0) ? -delta : delta;

			if (test > 10000000L)
				continue;

			if ((tested == 0) || (delta < delta_best))
			{
				tested					= 1;
				delta_best				= delta;

				hdlc->usc.brg0.clk_src	= data[i].brg0->clk_src;
				hdlc->usc.brg0.enable	= data[i].brg0->enable;
				hdlc->usc.brg0.divider	= tc0 - 1;

				hdlc->usc.ctr0.rate		= data[i].ctr0->rate;
				hdlc->usc.ctr0.clk_src	= data[i].ctr0->clk_src;

				hdlc->usc.tx.clk_src	= data[i].txclk->clk_src;

				hdlc->tx.bit_rate		= (s32) (test + 0.5);
			}
		} // j
	} // i
}


