// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/usc_cfg_rxc_ctr_brg_dpll.c $
// $Rev: 23185 $
// $Date: 2013-09-30 17:54:35 -0500 (Mon, 30 Sep 2013) $

#include "main.h"



// variables ******************************************************************

static const struct
{
	s32		div;		//							32, 16, 8
	s32		rate;		// hdlc->usc.dpll.rate		32, 16, 8
} dpll[]	=
{
	// div	rate
	{ 8,	SIO4_HDLC_USC_DPLL_RATE_8X	},
	{ 16,	SIO4_HDLC_USC_DPLL_RATE_16X	},
	{ 32,	SIO4_HDLC_USC_DPLL_RATE_32X	}
};



//*****************************************************************************
static float _use_rxc_dpll(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	float		delta;
	float		delta_best	= -1;
	int			i;
	float		rate;
	sio4_hdlc_t	tmp			= hdlc[0];

	for (i = 0; i < (int) ARRAY_ELEMENTS(dpll); i++)
	{
		rate	= (float) tmp.osc.prog;
		rate	/= dpll[i].div;

		delta	= rate - bit_rate;
		delta	= (delta < 0) ? -delta : delta;

		if (rate > 10000000L)
			continue;

		if ((delta_best < 0) || (delta < delta_best))
		{
			delta_best				= delta;
			tmp.rx.bit_rate			= (s32) (rate + 0.5);
			tmp.usc.dpll.clk_src	= SIO4_HDLC_USC_DPLL_CLK_SRC_RXC_PIN;
			tmp.usc.dpll.rate		= dpll[i].rate;
		}
	}

	if (delta_best >= 0)
		hdlc[0]	= tmp;

	return(delta_best);
}



//*****************************************************************************
static float _reuse_rxc_ctr0_brg0_txclock(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	long		brg;
	float		ctr;
	float		delta;
	float		delta_best	= -1;
	int			i;
	float		rate;
	sio4_hdlc_t	tmp			= hdlc[0];

	for (;;)	// A convenience loop.
	{
		if (hdlc->usc.tx.clk_src != SIO4_HDLC_USC_TX_CLK_SRC_BRG0)
			break;

		if (hdlc->usc.brg0.clk_src != SIO4_HDLC_USC_BRG0_CLK_SRC_CTR0)
			break;

		if (hdlc->usc.ctr0.clk_src != SIO4_HDLC_USC_CTR0_CLK_SRC_RXC_PIN)
			break;

		switch (hdlc->usc.ctr0.rate)
		{
			default:
			case SIO4_HDLC_USC_CTR0_RATE_32X:	ctr	= 32;	break;
			case SIO4_HDLC_USC_CTR0_RATE_16X:	ctr	= 16;	break;
			case SIO4_HDLC_USC_CTR0_RATE_8X:	ctr	= 8;	break;
			case SIO4_HDLC_USC_CTR0_RATE_4X:	ctr	= 4;	break;
		}

		brg	= hdlc->usc.brg0.divider + 1;

		for (i = 0; i < (int) ARRAY_ELEMENTS(dpll); i++)
		{
			rate	= (float) tmp.osc.prog;
			rate	/= ctr;
			rate	/= brg;
			rate	/= dpll[i].div;
			delta	= rate - bit_rate;
			delta	= (delta < 0) ? -delta : delta;

			if (rate > 10000000L)
				continue;

			if ((delta_best < 0) || (delta < delta_best))
			{
				delta_best				= delta;
				tmp.rx.bit_rate			= (s32) (rate + 0.5);
				tmp.usc.dpll.clk_src	= SIO4_HDLC_USC_DPLL_CLK_SRC_BRG0;
				tmp.usc.dpll.rate		= dpll[i].rate;
			}
		}

		break;
	}

	if (delta_best >= 0)
		hdlc[0]	= tmp;

	return(delta_best);
}



//*****************************************************************************
static float _reuse_rxc_brg0_txclock(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	long		brg;
	float		delta;
	float		delta_best	= -1;
	int			i;
	float		rate;
	sio4_hdlc_t	tmp			= hdlc[0];

	for (;;)	// A convenience loop.
	{
		if (hdlc->usc.tx.clk_src != SIO4_HDLC_USC_TX_CLK_SRC_BRG0)
			break;

		if (hdlc->usc.brg0.clk_src != SIO4_HDLC_USC_BRG0_CLK_SRC_RXC_PIN)
			break;

		brg	= hdlc->usc.brg0.divider + 1;

		for (i = 0; i < (int) ARRAY_ELEMENTS(dpll); i++)
		{
			rate	= (float) tmp.osc.prog;
			rate	/= brg;
			rate	/= dpll[i].div;
			delta	= rate - bit_rate;
			delta	= (delta < 0) ? -delta : delta;

			if (rate > 10000000L)
				continue;

			if ((delta_best < 0) || (delta < delta_best))
			{
				delta_best				= delta;
				tmp.rx.bit_rate			= (s32) (rate + 0.5);
				tmp.usc.dpll.clk_src	= SIO4_HDLC_USC_DPLL_CLK_SRC_BRG0;
				tmp.usc.dpll.rate		= dpll[i].rate;
			}
		}

		break;
	}

	if (delta_best >= 0)
		hdlc[0]	= tmp;

	return(delta_best);
}



//*****************************************************************************
static float _reuse_rxc_ctr0_use_brg1_dpll(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	s32			brg;
	s32			brg_min;
	s32			brg_max;
	float		ctr;
	float		delta;
	float		delta_best	= -1;
	int			i;
	float		rate;
	sio4_hdlc_t	tmp			= hdlc[0];

	for (;;)	// A convenience loop.
	{
		if ((hdlc->usc.tx.clk_src	== SIO4_HDLC_USC_TX_CLK_SRC_BRG0)	&&
			(hdlc->usc.brg0.clk_src == SIO4_HDLC_USC_BRG0_CLK_SRC_CTR0)	&&
			(hdlc->usc.ctr0.clk_src == SIO4_HDLC_USC_CTR0_CLK_SRC_RXC_PIN))
		{
			// Reuse CTR0 with BRG1
		}
		else
		if ((hdlc->usc.tx.clk_src	== SIO4_HDLC_USC_TX_CLK_SRC_CTR0)	&&
			(hdlc->usc.ctr0.clk_src == SIO4_HDLC_USC_CTR0_CLK_SRC_RXC_PIN))
		{
			// Reuse CTR0 with BRG1
		}
		else
		{
			// CTR0 is not in use
			break;
		}

		switch (hdlc->usc.ctr0.rate)
		{
			default:
			case SIO4_HDLC_USC_CTR0_RATE_32X:	ctr	= 32;	break;
			case SIO4_HDLC_USC_CTR0_RATE_16X:	ctr	= 16;	break;
			case SIO4_HDLC_USC_CTR0_RATE_8X:	ctr	= 8;	break;
			case SIO4_HDLC_USC_CTR0_RATE_4X:	ctr	= 4;	break;
		}

		for (i = 0; i < (int) ARRAY_ELEMENTS(dpll); i++)
		{
			brg		= (s32) (tmp.osc.prog / bit_rate / ctr / dpll[i].div);
			brg_min	= brg - 2;
			brg_max	= brg + 2;

			brg_min	= (brg_min < 2) ? 2 : (brg_min > 0x10000) ? 0x10000 : brg_min;
			brg_max	= (brg_max < 2) ? 2 : (brg_max > 0x10000) ? 0x10000 : brg_max;

			for (brg = brg_min; brg <= brg_max; brg++)
			{
				rate	= (float) tmp.osc.prog;
				rate	/= ctr;
				rate	/= brg;
				rate	/= dpll[i].div;

				delta	= rate - bit_rate;
				delta	= (delta < 0) ? -delta : delta;

				if (rate > 10000000L)
					continue;

				if ((delta_best < 0) || (delta < delta_best))
				{
					delta_best				= delta;
					tmp.rx.bit_rate			= (s32) (rate + 0.5);
					tmp.usc.brg1.clk_src	= SIO4_USC_BRG_CLK_SRC_CTR0;
					tmp.usc.brg1.divider	= brg - 1;
					tmp.usc.brg1.enable		= SIO4_HDLC_USC_BRG1_ENABLE_YES;
					tmp.usc.dpll.clk_src	= SIO4_HDLC_USC_DPLL_CLK_SRC_BRG1;
					tmp.usc.dpll.rate		= dpll[i].rate;
				}
			}
		}

		break;
	}

	if (delta_best >= 0)
		hdlc[0]	= tmp;

	return(delta_best);
}



//*****************************************************************************
static float _use_rxc_brg1_dpll(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	s32			brg;
	s32			brg_min;
	int			brg_max;
	float		delta;
	float		delta_best	= -1;
	int			i;
	float		rate;
	sio4_hdlc_t	tmp			= hdlc[0];

	for (i = 0; i < (int) ARRAY_ELEMENTS(dpll); i++)
	{
		brg		= (s32) (tmp.osc.prog / bit_rate / dpll[i].div);
		brg_min	= brg - 2;
		brg_max	= brg + 2;

		brg_min	= (brg_min < 2) ? 2 : (brg_min > 0x10000) ? 0x10000 : brg_min;
		brg_max	= (brg_max < 2) ? 2 : (brg_max > 0x10000) ? 0x10000 : brg_max;

		for (brg = brg_min; brg <= brg_max; brg++)
		{
			rate	= (float) tmp.osc.prog;
			rate	/= brg;
			rate	/= dpll[i].div;

			delta	= rate - bit_rate;
			delta	= (delta < 0) ? -delta : delta;

			if (rate > 10000000L)
				continue;

			if ((delta_best < 0) || (delta < delta_best))
			{
				delta_best				= delta;
				tmp.rx.bit_rate			= (s32) (rate + 0.5);
				tmp.usc.brg1.clk_src	= SIO4_USC_BRG_CLK_SRC_RXC_PIN;
				tmp.usc.brg1.divider	= brg - 1;
				tmp.usc.brg1.enable		= SIO4_HDLC_USC_BRG1_ENABLE_YES;
				tmp.usc.dpll.clk_src	= SIO4_HDLC_USC_DPLL_CLK_SRC_BRG1;
				tmp.usc.dpll.rate		= dpll[i].rate;
			}
		}
	}

	if (delta_best >= 0)
		hdlc[0]	= tmp;

	return(delta_best);
}



//*****************************************************************************
static float _use_rxc_ctr1_brg1_dpll(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	int			brg;
	int			brg_min;
	int			brg_max;
	s32			ctr;
	float		delta;
	float		delta_best	= -1;
	int			i;
	float		rate;
	sio4_hdlc_t	tmp			= hdlc[0];

	for (i = 0; i < (int) ARRAY_ELEMENTS(dpll); i++)
	{
		ctr		= dpll[i].div;	// use the DPLL value

		brg		= (s32) (tmp.osc.prog / bit_rate / ctr / dpll[i].div);
		brg_min	= brg - 2;
		brg_max	= brg + 2;

		brg_min	= (brg_min < 2) ? 2 : (brg_min > 0x10000) ? 0x10000 : brg_min;
		brg_max	= (brg_max < 2) ? 2 : (brg_max > 0x10000) ? 0x10000 : brg_max;

		for (brg = brg_min; brg <= brg_max; brg++)
		{
			rate	= (float) tmp.osc.prog;
			rate	/= ctr;
			rate	/= brg;
			rate	/= dpll[i].div;

			delta	= rate - bit_rate;
			delta	= (delta < 0) ? -delta : delta;

			if (rate > 10000000L)
				continue;

			if ((delta_best < 0) || (delta < delta_best))
			{
				delta_best				= delta;
				tmp.rx.bit_rate			= (s32) (rate + 0.5);
				tmp.usc.brg1.clk_src	= SIO4_USC_BRG_CLK_SRC_CTR1;
				tmp.usc.brg1.divider	= brg - 1;
				tmp.usc.brg1.enable		= SIO4_HDLC_USC_BRG1_ENABLE_YES;
				tmp.usc.ctr1.clk_src	= SIO4_USC_CTR_CLK_SRC_RXC_PIN;
				tmp.usc.ctr1.rate_src	= SIO4_USC_CTR1_RATE_DPLL;
				tmp.usc.dpll.clk_src	= SIO4_HDLC_USC_DPLL_CLK_SRC_BRG1;
				tmp.usc.dpll.rate		= dpll[i].rate;
			}
		}
	}

	if (delta_best >= 0)
		hdlc[0]	= tmp;

	return(delta_best);
}



//*****************************************************************************
void cfg_rxc_ctr_brg_dpll(sio4_hdlc_t* hdlc, s32 bit_rate)
{
	sio4_hdlc_t	best		= hdlc[0];
	float		delta;
	float		delta_best	= -1;
	sio4_hdlc_t	tmp;

	// Use RxC -> DPLL
	tmp		= hdlc[0];
	delta	= _use_rxc_dpll(&tmp, bit_rate);

	if ((delta_best < 0) || (delta < delta_best))
	{
		delta_best	= delta;
		best		= tmp;
	}

	// Resuse RxC -> CTR0 -> BRG0 -> TxClock
	tmp		= hdlc[0];
	delta	= _reuse_rxc_ctr0_brg0_txclock(&tmp, bit_rate);

	if ((delta_best < 0) || (delta < delta_best))
	{
		delta_best	= delta;
		best		= tmp;
	}

	// Resuse RxC -> BRG0 -> TxClock
	tmp		= hdlc[0];
	delta	= _reuse_rxc_brg0_txclock(&tmp, bit_rate);

	if ((delta_best < 0) || (delta < delta_best))
	{
		delta_best	= delta;
		best		= tmp;
	}

	// Resuse RxC -> CTR0, use BRG1 -> DPLL
	tmp		= hdlc[0];
	delta	= _reuse_rxc_ctr0_use_brg1_dpll(&tmp, bit_rate);

	if ((delta_best < 0) || (delta < delta_best))
	{
		delta_best	= delta;
		best		= tmp;
	}

	// Use RxC -> BRG1 -> DPLL
	tmp		= hdlc[0];
	delta	= _use_rxc_brg1_dpll(&tmp, bit_rate);

	if ((delta_best < 0) || (delta < delta_best))
	{
		delta_best	= delta;
		best		= tmp;
	}

	// Use RxC -> CTR1 (DPLL) -> BRG1 -> DPLL
	tmp		= hdlc[0];
	delta	= _use_rxc_ctr1_brg1_dpll(&tmp, bit_rate);

	if ((delta_best < 0) || (delta < delta_best))
	{
		delta_best	= delta;
		best		= tmp;
	}

	// The overall results.
	hdlc[0]	= best;
}


