// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/sio4_hdlc_t.c $
// $Rev: 25475 $
// $Date: 2014-02-26 14:57:53 -0600 (Wed, 26 Feb 2014) $

#include "main.h"



//*****************************************************************************
const char* sio4_hdlc_t_access(device_t* dev, sio4_hdlc_t* hdlc, sio4_hdlc_action_t action)
{
	s32			arg;
	const char*	err		= NULL;
	int			errs;
	s32			fw		= 0;
	int			ret;

	for (;;)	// A convenience loop.
	{
		if (dev == NULL)
		{
			err	= "sio4_hdlc_t_access(dev,,)";
			break;
		}

		if (hdlc == NULL)
		{
			err	= "sio4_hdlc_t_access(,hdlc,)";
			break;
		}

		// Verify that this is a Z16C30 based board.
		errs	= sio4_query(dev->fd, SIO4_QUERY_FW_TYPE, &fw);

		if (errs)
		{
			err	= "sio4_query()";
			break;
		}

		if (fw != SIO4_FW_TYPE_Z16C30)
		{
			err	= "This is not a Z16C30 based SIO4.";
			break;
		}

		switch (action)
		{
			default:

				err	= "sio4_hdlc_t_access(,,action)";
				break;

			case SIO4_HDLC_ACTION_SHOW:

				gsc_label("sio4_hdlc_t Settings");
				printf("\n");
				gsc_label_level_inc();
				break;

			case SIO4_HDLC_ACTION_SET:

				// Initialize various settings before applying user settings.

				arg	= SIO4_HDLC_TX_ENABLE_NO_NOW;
				sio4_hdlc_t_tx_enable			(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_RX_ENABLE_NO_NOW;
				sio4_hdlc_t_rx_enable			(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_CABLE_ENABLE_NO;
				sio4_hdlc_t_cable_enable		(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_CABLE_PROTOCOL_DISABLE;
				sio4_hdlc_t_cable_protocol		(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_LOOPBACK_MODE_DISABLE;
				sio4_hdlc_t_cable_loopback_mode	(dev->fd, &arg,	action, &err);

				arg	= SIO4_HDLC_CABLE_TERM_ENABLE_NO;
				sio4_hdlc_t_cable_term_enable	(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_CABLE_LEGACY_TXC_DISABLE;
				sio4_hdlc_t_cable_legacy_txc	(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_CABLE_LEGACY_TXD_CTS_TRI;
				sio4_hdlc_t_cable_legacy_txd_cts(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_CABLE_LEGACY_RXC_DISABLE;
				sio4_hdlc_t_cable_legacy_rxc	(dev->fd, &arg, action, &err);

				arg	= SIO4_HDLC_CABLE_LEGACY_RXD_DCD_DISABLE;
				sio4_hdlc_t_cable_legacy_rxd_dcd(dev->fd, &arg, action, &err);

				break;

			case SIO4_HDLC_ACTION_GET:
			case SIO4_HDLC_ACTION_INIT:
			case SIO4_HDLC_ACTION_VERIFY:

				break;
		}

		if (err)
			break;

		sio4_hdlc_t_osc_ref					(dev->fd, &hdlc->osc.ref,				action, &err);
		sio4_hdlc_t_osc_prog				(dev->fd, &hdlc->osc.prog,				action, &err);

		sio4_hdlc_t_usc_mode				(dev->fd, &hdlc->usc.mode,				action, &err);
		sio4_hdlc_t_usc_txd					(dev->fd, &hdlc->usc.txd,				action, &err);
		sio4_hdlc_t_usc_cts					(dev->fd, &hdlc->usc.cts,				action, &err);
		sio4_hdlc_t_usc_cts_legacy			(dev->fd, &hdlc->usc.cts_legacy,		action, &err);
		sio4_hdlc_t_usc_dcd					(dev->fd, &hdlc->usc.dcd,				action, &err);
		sio4_hdlc_t_usc_dcd_legacy			(dev->fd, &hdlc->usc.dcd_legacy,		action, &err);
		sio4_hdlc_t_usc_tx_clk_src			(dev->fd, &hdlc->usc.tx.clk_src,		action, &err);
		sio4_hdlc_t_usc_tx_txc				(dev->fd, &hdlc->usc.tx.txc,			action, &err);
		sio4_hdlc_t_usc_tx_txc_legacy		(dev->fd, &hdlc->usc.tx.txc_legacy,		action, &err);
		sio4_hdlc_t_usc_rx_clk_src			(dev->fd, &hdlc->usc.rx.clk_src,		action, &err);
		sio4_hdlc_t_usc_rx_rxc				(dev->fd, &hdlc->usc.rx.rxc,			action, &err);
		sio4_hdlc_t_usc_rx_rxc_legacy		(dev->fd, &hdlc->usc.rx.rxc_legacy,		action, &err);
		sio4_hdlc_t_usc_brg0_enable			(dev->fd, &hdlc->usc.brg0.enable,		action, &err);
		sio4_hdlc_t_usc_brg0_clk_src		(dev->fd, &hdlc->usc.brg0.clk_src,		action, &err);
		sio4_hdlc_t_usc_brg0_divider		(dev->fd, &hdlc->usc.brg0.divider,		action, &err);
		sio4_hdlc_t_usc_brg0_mode			(dev->fd, &hdlc->usc.brg0.mode,			action, &err);
		sio4_hdlc_t_usc_brg1_enable			(dev->fd, &hdlc->usc.brg1.enable,		action, &err);
		sio4_hdlc_t_usc_brg1_clk_src		(dev->fd, &hdlc->usc.brg1.clk_src,		action, &err);
		sio4_hdlc_t_usc_brg1_divider		(dev->fd, &hdlc->usc.brg1.divider,		action, &err);
		sio4_hdlc_t_usc_brg1_mode			(dev->fd, &hdlc->usc.brg1.mode,			action, &err);
		sio4_hdlc_t_usc_ctr0_clk_src		(dev->fd, &hdlc->usc.ctr0.clk_src,		action, &err);
		sio4_hdlc_t_usc_ctr0_rate			(dev->fd, &hdlc->usc.ctr0.rate,			action, &err);
		sio4_hdlc_t_usc_ctr1_clk_src		(dev->fd, &hdlc->usc.ctr1.clk_src,		action, &err);
		sio4_hdlc_t_usc_ctr1_rate_src		(dev->fd, &hdlc->usc.ctr1.rate_src,		action, &err);
		sio4_hdlc_t_usc_dpll_mode			(dev->fd, &hdlc->usc.dpll.mode,			action, &err);
		sio4_hdlc_t_usc_dpll_clk_src		(dev->fd, &hdlc->usc.dpll.clk_src,		action, &err);
		sio4_hdlc_t_usc_dpll_rate			(dev->fd, &hdlc->usc.dpll.rate,			action, &err);
		sio4_hdlc_t_usc_dpll_edge			(dev->fd, &hdlc->usc.dpll.edge,			action, &err);

		sio4_hdlc_t_tx_mode					(dev->fd, &hdlc->tx.mode,				action, &err);
		sio4_hdlc_t_tx_char_len				(dev->fd, &hdlc->tx.char_len,			action, &err);
		sio4_hdlc_t_tx_encoding				(dev->fd, &hdlc->tx.encoding,			action, &err);
		sio4_hdlc_t_tx_idle_cond			(dev->fd, &hdlc->tx.idle_cond,			action, &err);
		sio4_hdlc_t_tx_share_0				(dev->fd, &hdlc->tx.share_0,			action, &err);
		sio4_hdlc_t_tx_underrun				(dev->fd, &hdlc->tx.underrun,			action, &err);
		sio4_hdlc_t_tx_wait_underrun		(dev->fd, &hdlc->tx.wait_underrun,		action, &err);
		sio4_hdlc_t_tx_crc_enable			(dev->fd, &hdlc->tx.crc.enable,			action, &err);
		sio4_hdlc_t_tx_crc_type				(dev->fd, &hdlc->tx.crc.type,			action, &err);
		sio4_hdlc_t_tx_crc_preset			(dev->fd, &hdlc->tx.crc.preset,			action, &err);
		sio4_hdlc_t_tx_crc_on_end			(dev->fd, &hdlc->tx.crc.on_end,			action, &err);
		sio4_hdlc_t_tx_parity_enable		(dev->fd, &hdlc->tx.parity.enable,		action, &err);
		sio4_hdlc_t_tx_parity_type			(dev->fd, &hdlc->tx.parity.type,		action, &err);
		sio4_hdlc_t_tx_preamble_enable		(dev->fd, &hdlc->tx.preamble.enable,	action, &err);
		sio4_hdlc_t_tx_preamble_flag		(dev->fd, &hdlc->tx.preamble.flag,		action, &err);
		sio4_hdlc_t_tx_preamble_pattern		(dev->fd, &hdlc->tx.preamble.pattern,	action, &err);
		sio4_hdlc_t_tx_preamble_length		(dev->fd, &hdlc->tx.preamble.length,	action, &err);
		sio4_hdlc_t_tx_fifo_size			(dev->fd, &hdlc->tx.fifo.size,			action, &err);
		sio4_hdlc_t_tx_fifo_ae				(dev->fd, &hdlc->tx.fifo.ae,			action, &err);
		sio4_hdlc_t_tx_fifo_af				(dev->fd, &hdlc->tx.fifo.af,			action, &err);
		sio4_hdlc_t_tx_fifo_empty_cfg		(dev->fd, &hdlc->tx.fifo.empty_cfg,		action, &err);
		sio4_hdlc_t_tx_fifo_space_cfg		(dev->fd, &hdlc->tx.fifo.space_cfg,		action, &err);
		sio4_hdlc_t_tx_io_mode				(dev->fd, &hdlc->tx.io.mode,			action, &err);
		sio4_hdlc_t_tx_io_pio_thresh		(dev->fd, &hdlc->tx.io.pio_thresh,		action, &err);
		sio4_hdlc_t_tx_io_timeout			(dev->fd, &hdlc->tx.io.timeout,			action, &err);
		sio4_hdlc_t_tx_io_overrun			(dev->fd, &hdlc->tx.io.overrun,			action, &err);
		sio4_hdlc_t_tx_enable				(dev->fd, &hdlc->tx.enable,				action, &err);
		sio4_hdlc_t_tx_bit_rate				(dev->fd, &hdlc->tx.bit_rate,			action, &err);

		sio4_hdlc_t_rx_mode					(dev->fd, &hdlc->rx.mode,				action, &err);
		sio4_hdlc_t_rx_adrs					(dev->fd, &hdlc->rx.adrs,				action, &err);
		sio4_hdlc_t_rx_adrs_ctrl			(dev->fd, &hdlc->rx.adrs_ctrl,			action, &err);
		sio4_hdlc_t_rx_char_len				(dev->fd, &hdlc->rx.char_len,			action, &err);
		sio4_hdlc_t_rx_encoding				(dev->fd, &hdlc->rx.encoding,			action, &err);
		sio4_hdlc_t_rx_queue_abort			(dev->fd, &hdlc->rx.queue_abort,		action, &err);
		sio4_hdlc_t_rx_crc_enable			(dev->fd, &hdlc->rx.crc.enable,			action, &err);
		sio4_hdlc_t_rx_crc_type				(dev->fd, &hdlc->rx.crc.type,			action, &err);
		sio4_hdlc_t_rx_crc_preset			(dev->fd, &hdlc->rx.crc.preset,			action, &err);
		sio4_hdlc_t_rx_parity_enable		(dev->fd, &hdlc->rx.parity.enable,		action, &err);
		sio4_hdlc_t_rx_parity_type			(dev->fd, &hdlc->rx.parity.type,		action, &err);
		sio4_hdlc_t_rx_fifo_size			(dev->fd, &hdlc->rx.fifo.size,			action, &err);
		sio4_hdlc_t_rx_fifo_ae				(dev->fd, &hdlc->rx.fifo.ae,			action, &err);
		sio4_hdlc_t_rx_fifo_af				(dev->fd, &hdlc->rx.fifo.af,			action, &err);
		sio4_hdlc_t_rx_fifo_full_cfg		(dev->fd, &hdlc->rx.fifo.full_cfg,		action, &err);
		sio4_hdlc_t_rx_io_mode				(dev->fd, &hdlc->rx.io.mode,			action, &err);
		sio4_hdlc_t_rx_io_pio_thresh		(dev->fd, &hdlc->rx.io.pio_thresh,		action, &err);
		sio4_hdlc_t_rx_io_timeout			(dev->fd, &hdlc->rx.io.timeout,			action, &err);
		sio4_hdlc_t_rx_io_overrun			(dev->fd, &hdlc->rx.io.overrun,			action, &err);
		sio4_hdlc_t_rx_io_underrun			(dev->fd, &hdlc->rx.io.underrun,		action, &err);
		sio4_hdlc_t_rx_sync_byte			(dev->fd, &hdlc->rx.sync_byte,			action, &err);
		sio4_hdlc_t_rx_status_word			(dev->fd, &hdlc->rx.status_word,		action, &err);
		sio4_hdlc_t_rx_time_stamp_enable	(dev->fd, &hdlc->rx.time_stamp.enable,	action, &err);
		sio4_hdlc_t_rx_time_stamp_clk_src	(dev->fd, &hdlc->rx.time_stamp.clk_src,	action, &err);
		sio4_hdlc_t_rx_enable				(dev->fd, &hdlc->rx.enable,				action, &err);
		sio4_hdlc_t_rx_bit_rate				(dev->fd, &hdlc->rx.bit_rate,			action, &err);

		if (action == SIO4_HDLC_ACTION_SET)
		{
			// Clear the transmit side.
			arg	= 1;
			ret	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_TX_FIFO_RESET, &arg);
			err	= err ? err : ret ? "SIO4_IOCTL_TX_FIFO_RESET" : NULL;

			arg	= SIO4_USC_SEND_CMD_TX_FIFO_PURGE;
			ret	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_USC_SEND_COMMAND, &arg);
			err	= err ? err : ret ? "SIO4_USC_SEND_CMD_TX_FIFO_PURGE" : NULL;

			// Clear the receive side.
			arg	= SIO4_USC_SEND_CMD_RX_FIFO_PURGE;
			ret	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_USC_SEND_COMMAND, &arg);
			err	= err ? err : ret ? "SIO4_USC_SEND_CMD_RX_FIFO_PURGE" : NULL;

			arg	= 1;
			ret	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_RX_FIFO_RESET, &arg);
			err	= err ? err : ret ? "SIO4_IOCTL_RX_FIFO_RESET" : NULL;

			// Enable required interrupts.
			arg	= SIO4_IRQ_USC_RX_BREAK_ABORT		// HDLC: Abort sequence detected
				| SIO4_IRQ_USC_RX_ABORT_PAR_ERROR	// HDLC: Abort or Parity Error
				| SIO4_IRQ_USC_RX_OVERRUN
				| SIO4_IRQ_USC_MISC_RCC_UNDERRUN;

			if (hdlc->usc.dpll.mode != SIO4_HDLC_USC_DPLL_MODE_DISABLE)
				arg	|= SIO4_IRQ_USC_MISC_DPLL_DESYNC;

			ret	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_IRQ_USC_ENABLE, &arg);
			err	= err ? err : ret ? "SIO4_IOCTL_IRQ_USC_ENABLE" : NULL;
		}

		sio4_hdlc_t_cable_txaux				(dev->fd, &hdlc->cable.txaux,			action, &err);
		sio4_hdlc_t_cable_txc				(dev->fd, &hdlc->cable.txc,				action, &err);
		sio4_hdlc_t_cable_legacy_txc		(dev->fd, &hdlc->cable.legacy.txc,		action, &err);
		sio4_hdlc_t_cable_txd				(dev->fd, &hdlc->cable.txd,				action, &err);
		sio4_hdlc_t_cable_legacy_txd_cts	(dev->fd, &hdlc->cable.legacy.txd_cts,	action, &err);
		sio4_hdlc_t_cable_rts				(dev->fd, &hdlc->cable.rts,				action, &err);
		sio4_hdlc_t_cable_dcd				(dev->fd, &hdlc->cable.dcd,				action, &err);
		sio4_hdlc_t_cable_legacy_rxd_dcd	(dev->fd, &hdlc->cable.legacy.rxd_dcd,	action, &err);
		sio4_hdlc_t_cable_dtr_dsr			(dev->fd, &hdlc->cable.dtr_dsr,			action, &err);
		sio4_hdlc_t_cable_legacy_rxc		(dev->fd, &hdlc->cable.legacy.rxc,		action, &err);

		sio4_hdlc_t_cable_mode				(dev->fd, &hdlc->cable.mode,			action, &err);
		sio4_hdlc_t_cable_protocol			(dev->fd, &hdlc->cable.protocol,		action, &err);
		sio4_hdlc_t_cable_loopback_mode		(dev->fd, &hdlc->cable.loopback.mode,	action, &err);
		sio4_hdlc_t_cable_term_enable		(dev->fd, &hdlc->cable.term.enable,		action, &err);
		sio4_hdlc_t_cable_enable			(dev->fd, &hdlc->cable.enable,			action, &err);

		switch (action)
		{
			case SIO4_HDLC_ACTION_GET:
			case SIO4_HDLC_ACTION_INIT:
			case SIO4_HDLC_ACTION_SET:
			case SIO4_HDLC_ACTION_VERIFY:
			default:

				break;

			case SIO4_HDLC_ACTION_SHOW:

				gsc_label_level_dec();
				break;
		}

		break;
	}

	return(err);
}


