// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/rx_flush.c $
// $Rev: 23019 $
// $Date: 2013-08-27 14:49:19 -0500 (Tue, 27 Aug 2013) $

#include "main.h"


//*****************************************************************************
static int _args_validate(int fd, device_t** dev)
{
	int	ret	= -EINVAL;

	for (;;)	// A convenience loop.
	{
		// Validate the "dev" argument.

		if (dev == NULL)
			break;

		dev[0]	= lib_fd_find_inc(fd);

		if (dev[0] == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		ret	= 0;
		break;
	}

	return(ret);
}



//*****************************************************************************
static int _env_validate(device_t* dev)
{
	int	ret	= 0;

	ret	|= rx_flush_active(dev);
	ret	|= rx_frame_active(dev);
	ret	= ret ? -EBUSY : 0;
	return(ret);
}



//*****************************************************************************
static int _rx_flush(device_t* dev)
{
	s32	arg;
	int	ret		= 0;
	int	sts;

	// Flush the USC receiver.
	arg	= SIO4_USC_SEND_CMD_RX_PURGE;
	sts	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_USC_SEND_COMMAND, &arg);
	ret	= ret ? ret : sts;

	// Flush the Rx FIFO.
	arg	= 1;
	sts	= sio4_hdlc_ioctl(dev->fd, SIO4_IOCTL_RX_FIFO_RESET, &arg);
	ret	= ret ? ret : sts;

	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_hdlc_rx_flush
*
*	Purpose:
*
*		Flush the rx side of the device and software.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_hdlc_rx_flush(int fd)
{
	device_t*	dev		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_hdlc_lib_init();

		if (ret)
			break;

		// Validate the arguments.
		ret	= _args_validate(fd, &dev);

		if (ret)
			break;

		// Gain exclusive access to the device.
		ret	= os_sem_lock(&dev->sem);

		if (ret)
			break;

		// Validate the state.
		ret	= _env_validate(dev);

		if (ret)
		{
			os_sem_unlock(&dev->sem);
			break;
		}

		// Gain exclusive access to the Rx stream.
		ret	= os_sem_lock(&dev->rx.sem);
		os_sem_unlock(&dev->sem);

		if (ret)
			break;

		// Record our presence.
		dev->rx.rx_flush	= 1;
		os_sem_unlock(&dev->rx.sem);

		// Perform the operation.
		ret	= _rx_flush(dev);

		// Cleanup.
		dev->rx.rx_flush	= 0;
		break;
	}

	if (dev)
		lib_dev_dec(dev);

	return(ret);
}



//*****************************************************************************
int rx_flush_active(device_t* dev)
{
	int	ret;

	ret	= dev->rx.rx_flush ? 1 : 0;
	return(ret);
}


