// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/rx_fifo_size.c $
// $Rev: 23019 $
// $Date: 2013-08-27 14:49:19 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Rx FIFO Size");

	if (set == -1)
	{
		printf("This service is not supported by this board.\n");
	}
	else if ((set < 0) || (set > 0xFFFF))
	{
		errs++;
		printf("Invalid value: %ld\n", (long) set);
	}
	else if (set % 1024)
	{
		gsc_label_long_comma(set);
		printf(" bytes\n");
	}
	else
	{
		gsc_label_long_comma(set / 1024);
		printf("K bytes\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_hdlc_t_rx_fifo_size(
	int					fd,
	s32*				arg,
	sio4_hdlc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "hdlc->rx.fifo.size"
	int			errs	= 0;
	const char*	sts		= NULL;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_HDLC_ACTION_GET:
		case SIO4_HDLC_ACTION_INIT:

				errs	= sio4_query(fd, SIO4_QUERY_FIFO_SIZE_RX, arg);
				break;

		case SIO4_HDLC_ACTION_SET:

				// We do nothing here.
				break;

		case SIO4_HDLC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_HDLC_ACTION_VERIFY:

				if (arg[0] < -1)
					errs	= 1;

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


