// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/rx_adrs_ctrl.c $
// $Rev: 23019 $
// $Date: 2013-08-27 14:49:19 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC Rx Address/Control");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_OFF:

			ptr	= "No Address or Control fields";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_16:

			ptr	= "16-bits, Combined";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_24:

			ptr	= "24-bits, Combined";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_32:

			ptr	= "32-bits, Combined";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_EA_16:

			ptr	= "Extended Address, 16-bit Control";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_EA_24:

			ptr	= "Extended Address, 24-bit Control";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_EAC8:

			ptr	= "Extended Address, 8-bit w/ Extended Control";
			break;

		case SIO4_HDLC_RX_ADRS_CTRL_EAC16:

			ptr	= "Extended Address, 16-bit w/ Extended Control";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_hdlc_t_rx_adrs_ctrl(
	int					fd,
	s32*				arg,
	sio4_hdlc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "hdlc->rx.adrs_ctrl"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_HDLC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_hdlc_rx_adrs_ctrl(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_HDLC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_HDLC_RX_ADRS_CTRL_16;
				break;

		case SIO4_HDLC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_hdlc_rx_adrs_ctrl(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_HDLC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_HDLC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:			errs	= 1;	break;
					case -1:
					case SIO4_HDLC_RX_ADRS_CTRL_OFF:
					case SIO4_HDLC_RX_ADRS_CTRL_16:
					case SIO4_HDLC_RX_ADRS_CTRL_24:
					case SIO4_HDLC_RX_ADRS_CTRL_32:
					case SIO4_HDLC_RX_ADRS_CTRL_EA_16:
					case SIO4_HDLC_RX_ADRS_CTRL_EA_24:
					case SIO4_HDLC_RX_ADRS_CTRL_EAC8:
					case SIO4_HDLC_RX_ADRS_CTRL_EAC16:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


