// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/main.h $
// $Rev: 33920 $
// $Date: 2015-10-07 14:47:33 -0500 (Wed, 07 Oct 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "sio4_dsl.h"
#include "sio4_utils.h"
#include "sio4_hdlc.h"



// #defines *******************************************************************

#define	SIO4_HDLC_LIB_VER	"0.10"
// 0.10	API prototypes and return values mimic the SIO4 API services.
//		Replaced some time code with calls to OS utility code.
// 0.9	Removed error status when oscillator program frequency is not recorded."
// 0.8	Changed "isoch" text to "isoc", lower and upper case.
// 0.7	Updated the clocking configuration code to not use the DPLL for the Tx Clock.
// 0.6	Added sem create/destroy to open/close and tx/rx open/close.
//		Added structure memset() calls to open/close and tx/rx open/close.
//		Additional LINTing.
// 0.5	LINTing for INtime.
//		Changed the library version number to a string.
//		Moved the version string to an internal header.
// 0.4	Prerelease for 10/15/2013.
//		Non-Z16C30 boards are not accessed.
// 0.3	Prerelease for 9/30/2013.
//		LINted the sources.
//		Removed Document Source Library calls.
// 0.2	Prerelease for 8/16/2013.
// 0.1	Prerelease for 3/7/2013.

#define	ARRAY_ELEMENTS(a)		(sizeof((a))/sizeof((a)[0]))

#define	D1		(0x1 << 1)
#define	D2		(0x1 << 2)
#define	D3		(0x1 << 3)
#define	D5		(0x1 << 5)
#define	D6		(0x1 << 6)
#define	D7		(0x1 << 7)
#define	D8		(0x1 << 8)
#define	D10		(0x1 << 10)
#define	D11		(0x1 << 11)
#define	D12		(0x1 << 12)
#define	D13		(0x1 << 13)

#undef	ERROR



// data types *****************************************************************

typedef struct
{
	os_sem_t		sem;
	int				fd;
	int				users;

	struct
	{
		os_sem_t	sem;
		u16			remainder;

		s32			put;
		s32			get;
		char		buf[65L * 1024];

		// These maintain the state of these activities.
		int			rx_flush;		// Number of active Rx Flush calls.
		int			rx_frame;		// Number of active Rx Frame calls.
	} rx;

	struct
	{
		os_sem_t	sem;
		int			stream_init;	// Initialized device for Tx operations?
		int			tx_underrun;	// Did we encounter a Tx Underrun?

		// These maintain the state of these activities.
		int			tx_abort;		// Number of active Tx Abort calls.
		int			tx_flush;		// Number of active Tx Flush calls.
		int			tx_frame;		// Number of active Tx Frame calls.
		int			tx_wait;		// Number of active Tx Wait calls.
	} tx;

} device_t;



// prototypes *****************************************************************

void		cfg_rxc_ctr_brg_dpll(sio4_hdlc_t* hdlc, s32 bit_rate);
void		cfg_rxc_ctr0_brg0_txclk(sio4_hdlc_t* hdlc, s32 bit_rate);
//void		cfg_rxc_ctr0_brg1_dpll(sio4_hdlc_t* hdlc, s32 bit_rate);
void		cfg_txc_ctr0_brg0_txclk(sio4_hdlc_t* hdlc, s32 bit_rate);

device_t*	lib_dev_alloc_inc(void);			// returns NULL or valid pointer
int			lib_dev_dec(device_t* dev);			// returns 0 or -errno
int			lib_dev_dec_release(device_t* dev);	// returns 0 or -errno
device_t*	lib_fd_find_inc(int fd);			// returns NULL for error

void		rx_close(device_t* dev);
int			rx_flush_active(device_t* dev);
int			rx_frame_active(device_t* dev);
int			rx_open(device_t* dev);				// returns 0 or -errno

const char*	sio4_hdlc_t_access(device_t* dev, sio4_hdlc_t* hdlc, sio4_hdlc_action_t action);	// returns NULL or error

void		tx_close(device_t* dev);
int			tx_open(device_t* dev);				// returns 0 or -errno
int			tx_abort_active(device_t* dev);
int			tx_flush_active(device_t* dev);
int			tx_frame_active(device_t* dev);
int			tx_wait_active(device_t* dev);



#endif
