// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/lib.c $
// $Rev: 23185 $
// $Date: 2013-09-30 17:54:35 -0500 (Mon, 30 Sep 2013) $

#include "main.h"



// variables ******************************************************************

static	int			_initialized;
static device_t*	_list[10]; // tbd 100];
static	os_sem_t	_sem;



//*****************************************************************************
device_t* lib_dev_alloc_inc(void)
{
	device_t*	dev		= NULL;
	int			i;
	int			ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_hdlc_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		for (i = 0; i < (int) ARRAY_ELEMENTS(_list); i++)
		{
			if (_list[i] == NULL)
			{
				dev	= malloc(sizeof(device_t));

				if (dev)
				{
					memset(dev, 0, sizeof(device_t));
					dev->users++;
					_list[i]	= dev;
					break;
				}
			}
		}

		os_sem_unlock(&_sem);
		break;
	}

	return(dev);
}



//*****************************************************************************
int lib_dev_dec(device_t* dev)
{
	int	ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_hdlc_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		if (dev->users > 0)
			dev->users--;

		os_sem_unlock(&_sem);
		break;
	}

	return(ret);
}



//*****************************************************************************
int lib_dev_dec_release(device_t* dev)
{
	int	i;
	int	ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_hdlc_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		if (dev->users > 1)
		{
			os_sem_unlock(&_sem);
			ret	= -EBUSY;
			break;
		}

		for (i = 0; i < (int) ARRAY_ELEMENTS(_list); i++)
		{
			if (_list[i] == dev)
			{
				_list[i]	= NULL;
				break;
			}
		}

		os_sem_unlock(&_sem);
		break;
	}

	return(ret);
}



//*****************************************************************************
device_t* lib_fd_find_inc(int fd)
{
	device_t*	dev	= NULL;
	int			i;
	int			ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_hdlc_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		for (i = 0; i < (int) ARRAY_ELEMENTS(_list); i++)
		{
			if (_list[i] == NULL)
				continue;

			if (_list[i]->fd == fd)
			{
				dev	= _list[i];
				break;
			}
		}

		os_sem_unlock(&_sem);
		break;
	}

	return(dev);
}



//*****************************************************************************
int sio4_hdlc_lib_init(void)
{
	int	ret	= 0;

	for (;;)	// A convenience loop.
	{
		if (_initialized)
			break;

		_initialized	= 1;
		ret				= os_sem_create(&_sem);

		if (ret)
			_initialized	= 0;

		break;
	}

	return(ret);
}


