// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/get.c $
// $Rev: 23019 $
// $Date: 2013-08-27 14:49:19 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_hdlc_get
*
*	Purpose:
*
*		Retrieve the HDLC settings from the specified SIO4.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		hdlc	The requested settings are recorded here.
*
*		err		If a field value is invalid, this will name the field.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_hdlc_get(int fd, sio4_hdlc_t* hdlc, const char** err)
{
	device_t*	dev;
	const char*	psz		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_hdlc_lib_init();

		if (ret)
		{
			psz	= "sio4_hdlc_lib_init";
			break;
		}

		// Validate the received arguments.

		if (hdlc == NULL)
		{
			psz	= "sio4_hdlc_get(,hdlc,)";
			break;
		}

		// Gain access to the device.
		dev	= lib_fd_find_inc(fd);

		if (dev == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		// Begin working.
		memset(hdlc, 0, sizeof(sio4_hdlc_t));
		psz	= sio4_hdlc_t_access(dev, hdlc, SIO4_HDLC_ACTION_GET);

		if (psz == NULL)
			psz	= sio4_hdlc_t_access(dev, hdlc, SIO4_HDLC_ACTION_VERIFY);

		if (psz)
			ret	= -EINVAL;

		lib_dev_dec(dev);
		break;
	}

	if (err)
		err[0]	= psz;

	return(ret);
}


