// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/cable_legacy_rxc.c $
// $Rev: 23019 $
// $Date: 2013-08-27 14:49:19 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("Cable RxC (Legacy)");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_HDLC_CABLE_LEGACY_RXC_DISABLE:

			ptr	= "Disable";
			break;

		case SIO4_HDLC_CABLE_LEGACY_RXC_UP:

			ptr	= "Upper";
			break;

		case SIO4_HDLC_CABLE_LEGACY_RXC_LOW:

			ptr	= "Lower";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_hdlc_t_cable_legacy_rxc(
	int					fd,
	s32*				arg,
	sio4_hdlc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "hdlc->cable.legacy.rxc"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_HDLC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_z16_leg_rxc(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_HDLC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_HDLC_CABLE_LEGACY_RXC_LOW;
				break;

		case SIO4_HDLC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_z16_leg_rxc(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_HDLC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_HDLC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:					errs	= 1;	break;
					case -1:
					case SIO4_HDLC_CABLE_LEGACY_RXC_DISABLE:
					case SIO4_HDLC_CABLE_LEGACY_RXC_UP:
					case SIO4_HDLC_CABLE_LEGACY_RXC_LOW:		break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


