// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/osc_idc2053b_sio4.c $
// $Rev: 23033 $
// $Date: 2013-08-27 15:08:43 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



//*****************************************************************************
void osc_idc2053b_sio4_close(chan_data_t* chan)
{
	// We do nothing.
}



//*****************************************************************************
void osc_idc2053b_sio4_create(dev_data_t* dev)
{
	osc_idc2053b_t*	osc	= &dev->osc.idc2053b;

	memset(osc, 0, sizeof(osc[0]));
	os_sem_create(&osc->sem);
	osc->freq_ref	= OSC_FREQ_REF_DEFAULT;
}



//*****************************************************************************
void osc_idc2053b_sio4_destroy(dev_data_t* dev)
{
	osc_idc2053b_t*	osc	= &dev->osc.idc2053b;

	os_sem_destroy(&osc->sem);
	memset(osc, 0, sizeof(osc[0]));
}



//*****************************************************************************
int osc_idc2053b_sio4_measure_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret	= 0;

	if (arg[0] == -1)
	{
		// This is unsupported.
	}
	else if (arg[0] == 1)
	{
		// This is unsupported.
		arg[0]	= -1;
	}
	else
	{
		// This is an invalid value.
		ret	= -EINVAL;
	}

	return(ret);
}



//*****************************************************************************
void osc_idc2053b_sio4_open(chan_data_t* chan)
{
	// We do nothing.
}



//*****************************************************************************
int osc_idc2053b_sio4_program_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret	= 0;

	if (arg[0] == -1)
	{
		// This is unsupported.
	}
	else  if ((arg[0] < _1MHZ) || (arg[0] > _20MHZ))
	{
		ret	= -EINVAL;
	}
	else
	{
		// This is unsupported.
		arg[0]	= -1;
	}

	return(ret);
}



//*****************************************************************************
int osc_idc2053b_sio4_reference_ioctl(chan_data_t* chan, s32* arg)
{
	osc_idc2053b_t*	osc	= &chan->dev->osc.idc2053b;
	int				ret;

	ret	= os_sem_lock(&osc->sem);

	if (ret)
	{
		ret	= -ERESTARTSYS;
	}
	else if (arg[0] == -1)
	{
		arg[0]	= osc->freq_ref;
		ret		= 0;
		os_sem_unlock(&osc->sem);
	}
	else  if ((arg[0] < _1MHZ) || (arg[0] > _20MHZ))
	{
		ret	= -EINVAL;
		os_sem_unlock(&osc->sem);
	}
	else
	{
		osc->freq_ref	= arg[0];
		ret				= 0;
		os_sem_unlock(&osc->sem);
	}

	return(ret);
}


