// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/osc_fixed.c $
// $Rev: 18177 $
// $Date: 2012-09-26 10:28:50 -0500 (Wed, 26 Sep 2012) $

#include "main.h"



//*****************************************************************************
void osc_fixed_close(chan_data_t* chan)
{
	// We do nothing.
}



//*****************************************************************************
void osc_fixed_create(dev_data_t* dev)
{
	osc_fixed_t*	osc	= &dev->osc.fixed;

	memset(osc, 0, sizeof(osc[0]));
	os_sem_create(&osc->sem);
	osc->freq_ref	= OSC_FREQ_REF_DEFAULT;
}



//*****************************************************************************
void osc_fixed_destroy(dev_data_t* dev)
{
	osc_fixed_t*	osc	= &dev->osc.fixed;

	os_sem_destroy(&osc->sem);
	memset(osc, 0, sizeof(osc[0]));
}



//*****************************************************************************
int osc_fixed_measure_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret	= 0;

	if (arg[0] == -1)
	{
		// This is unsupported.
	}
	else if (arg[0] == 1)
	{
		// This is unsupported.
		arg[0]	= -1;
	}
	else
	{
		// This is an invalid value.
		ret	= -EINVAL;
	}

	return(ret);
}



//*****************************************************************************
void osc_fixed_open(chan_data_t* chan)
{
	// We do nothing.
}



//*****************************************************************************
int osc_fixed_program_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret	= 0;

	if (arg[0] == -1)
	{
		// This is unsupported.
	}
	else  if ((arg[0] < _1MHZ) || (arg[0] > _20MHZ))
	{
		ret	= -EINVAL;
	}
	else
	{
		// This is unsupported.
		arg[0]	= -1;
	}

	return(ret);
}



//*****************************************************************************
int osc_fixed_reference_ioctl(chan_data_t* chan, s32* arg)
{
	osc_fixed_t*	osc	= &chan->dev->osc.fixed;
	int				ret;

	ret	= os_sem_lock(&osc->sem);

	if (ret)
	{
		ret	= -ERESTARTSYS;
	}
	else if (arg[0] == -1)
	{
		arg[0]	= osc->freq_ref;
		ret		= 0;
		os_sem_unlock(&osc->sem);
	}
	else  if ((arg[0] < _1MHZ) || (arg[0] > _20MHZ))
	{
		ret	= -EINVAL;
		os_sem_unlock(&osc->sem);
	}
	else
	{
		osc->freq_ref	= arg[0];
		ret				= 0;
		os_sem_unlock(&osc->sem);
	}

	return(ret);
}


