// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/osc_cy22393_sio4.h $
// $Rev: 23033 $
// $Date: 2013-08-27 15:08:43 -0500 (Tue, 27 Aug 2013) $

#ifndef __OSC_CY22393_SIO4_H__
#define __OSC_CY22393_SIO4_H__

#include "osc_cy22393.h"



// typedefs *******************************************************************


typedef struct
{
	os_sem_t		sem;		// One access at a time.
	osc_cy22393_t	osc;
	u32				pd_max;		// Max divider value for board.

	u8				_06;		// Must be cached.
	u8				_07;		// Must be cached.
	u8				_18;		// Must be cached.
	u8				_19;		// Must be cached.
	u8				_1a;		// Must be cached.
	u8				_1b;		// Must be cached.

	struct
	{
		u32			freq_want;
		u32			freq_got;
		u8			pd;			// Firmware Post Divider.
	} chan[4];

} osc_cy22393_sio4_t;



// prototypes *****************************************************************

void	osc_cy22393_sio4_close(chan_data_t* chan);
void	osc_cy22393_sio4_create(dev_data_t* dev);
void	osc_cy22393_sio4_destroy(dev_data_t* dev);
int		osc_cy22393_sio4_measure_ioctl(chan_data_t* chan, s32* arg);
void	osc_cy22393_sio4_open(chan_data_t* chan);
int		osc_cy22393_sio4_program_ioctl(chan_data_t* chan, s32* arg);
int		osc_cy22393_sio4_reference_ioctl(chan_data_t* chan, s32* arg);



#endif
