// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/osc_cy22393.h $
// $Rev: 31815 $
// $Date: 2015-06-09 12:24:11 -0500 (Tue, 09 Jun 2015) $

#ifndef __OSC_CY22393_H__
#define __OSC_CY22393_H__



// #defines *******************************************************************

#define	CY22393_PT(p,p0)	((2 * ((p) + 3)) + (p0))
#define	CY22393_QT(q)		((q) + 2)

#define	OSC_FREQ_MAX		200000000L	// Max PLL based output from the oscillator.
#define	OSC_FREQ_MIN		8000L



// typedefs *******************************************************************

typedef enum
{
	CY22393_CLOCK_A,
	CY22393_CLOCK_B,
	CY22393_CLOCK_C,
	CY22393_CLOCK_D
} osc_cy22393_clock_id_t;

typedef enum
{
	CY22393_FREQ_SRC_REF	= 0x0,
	CY22393_FREQ_SRC_PLL1	= 0x2,		// Clk*FS: PLL1 Zero degrees.
	CY22393_FREQ_SRC_PLL2	= 0x4,		// Clk*FS: PLL2 Zero degrees.
	CY22393_FREQ_SRC_PLL3	= 0x6		// Clk*FS: PLL3 Zero degrees.
} osc_cy22393_freq_src_t;

typedef struct
{
	u8						enable;		// 0 - 1
	s32						freq_got;
	osc_cy22393_freq_src_t	freq_src;	// PLL 1/2/3 or Reference.
	u16						p;			// 0x0 - 0x3FF
	u8						p0;			// 0 - 1
	u8						lf;			// 0 - 4
	u8						q;			// 0x0 - 0xFF
} osc_cy22393_pll_t;

typedef struct
{
	osc_cy22393_clock_id_t	id;
	int						in_use;		// 0 = NO, else YES
	s32						freq_want;
	s32						freq_got;
	osc_cy22393_freq_src_t	freq_src;	// PLL 1/2/3 or Reference.
	u8						post_div;
} osc_cy22393_clock_t;

typedef struct
{
	u8	_08;
	u8	_0A;
	u8	_0C;
	u8	_0D;
	u8	_0E;
	u8	_0F;
	u8	_10;
	u8	_11;
	u8	_12;
	u8	_13;
	u8	_14;
	u8	_15;
	u8	_16;
	u8	_17;
	u8	_40;
	u8	_41;
	u8	_42;
} osc_cy22393_data_t;

typedef struct
{
	s32					freq_ref;
	osc_cy22393_clock_t	clock[4];
	osc_cy22393_pll_t	pll[3];
	osc_cy22393_data_t	data;
} osc_cy22393_t;

typedef struct
{
	s32	freq_ref;
	s32	freq_want;
	s32	freq_got;
} osc_cy22393_arg_t;



// prototypes *****************************************************************

int		osc_cy22393_program(osc_cy22393_t* osc, int index, osc_cy22393_arg_t* arg);
void	osc_cy22393_startup(osc_cy22393_t* osc, int reference);



#endif
