// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/osc.c $
// $Rev: 18177 $
// $Date: 2012-09-26 10:28:50 -0500 (Wed, 26 Sep 2012) $

#include "main.h"



//*****************************************************************************
void osc_close(chan_data_t* chan)
{
	switch (chan->dev->cache.osc_chip)
	{
		default:

			osc_unknown_close(chan);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			osc_cy22393_sio4_close(chan);
			break;

		case SIO4_OSC_CHIP_FIXED:

			osc_fixed_close(chan);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:

			osc_idc2053b_sio4_close(chan);
			break;
	}
}



//*****************************************************************************
void osc_create(dev_data_t* dev)
{
	switch (dev->cache.osc_chip)
	{
		default:

			osc_unknown_create(dev);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			osc_cy22393_sio4_create(dev);
			break;

		case SIO4_OSC_CHIP_FIXED:

			osc_fixed_create(dev);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:

			osc_idc2053b_sio4_create(dev);
			break;
	}
}



//*****************************************************************************
void osc_destroy(dev_data_t* dev)
{
	switch (dev->cache.osc_chip)
	{
		default:

			osc_unknown_destroy(dev);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			osc_cy22393_sio4_destroy(dev);
			break;

		case SIO4_OSC_CHIP_FIXED:

			osc_fixed_destroy(dev);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:

			osc_idc2053b_sio4_destroy(dev);
			break;
	}
}



//*****************************************************************************
int osc_measure_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret;

	switch (chan->dev->cache.osc_chip)
	{
		default:

			ret	= osc_unknown_measure_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			ret	= osc_cy22393_sio4_measure_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_FIXED:

			ret	= osc_fixed_measure_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:

			ret	= osc_idc2053b_sio4_measure_ioctl(chan, arg);
			break;
	}

	return(ret);
}



//*****************************************************************************
void osc_open(chan_data_t* chan)
{
	switch (chan->dev->cache.osc_chip)
	{
		default:

			osc_unknown_open(chan);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			osc_cy22393_sio4_open(chan);
			break;

		case SIO4_OSC_CHIP_FIXED:

			osc_fixed_open(chan);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:

			osc_idc2053b_sio4_open(chan);
			break;
	}
}



//*****************************************************************************
int osc_program_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret;

	switch (chan->dev->cache.osc_chip)
	{
		default:

			ret	= osc_unknown_program_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			ret	= osc_cy22393_sio4_program_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_FIXED:

			ret	= osc_fixed_program_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:


			ret	= osc_idc2053b_sio4_program_ioctl(chan, arg);
			break;
	}

	return(ret);
}



//*****************************************************************************
int osc_reference_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret;

	switch (chan->dev->cache.osc_chip)
	{
		default:

			ret	= osc_unknown_reference_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			ret	= osc_cy22393_sio4_reference_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_FIXED:

			ret	= osc_fixed_reference_ioctl(chan, arg);
			break;

		case SIO4_OSC_CHIP_IDC2053B:
		case SIO4_OSC_CHIP_IDC2053B_4:

			ret	= osc_idc2053b_sio4_reference_ioctl(chan, arg);
			break;
	}

	return(ret);
}


