// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_thread.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



// data types *****************************************************************

typedef struct
{
	os_thread_t*		thread;
	os_thread_data_t	data;
	long				(*func)(os_thread_data_t* data);
} _thread_data_t;



//*****************************************************************************
static DWORD RTFCNDCL _thread_function(LPVOID arg)
{
	long			l;
	_thread_data_t*	ptr	= arg;

	ptr->thread->started	= 1;

	l	= (ptr->func)(&ptr->data);

	ptr->thread->done	= 1;
	os_mem_data_free(ptr);
	return((DWORD) l);
}


//*****************************************************************************
int os_thread_create(os_thread_t* thread, long (*func)(os_thread_data_t* data), os_thread_data_t* data)
{
	int				i;
	_thread_data_t*	ptr;
	int				ret;

	for (;;)	// A convenience loop.
	{
		if ((thread == NULL) || (func == NULL) || (data == NULL))
		{
			ret	= -EINVAL;
			break;
		}

		ptr	= os_mem_data_alloc(sizeof(_thread_data_t));

		if (ptr == NULL)
		{
			ret	= -ENOMEM;
			break;
		}

		thread->started	= 0;
		ptr->thread		= thread;
		ptr->data		= data[0];
		ptr->func		= func;
		thread->handle	= RtCreateThread(
							NULL,
							0,
							_thread_function,
							ptr,
							0,
							&thread->thread_id);

		if (thread->handle == 0)
		{
			ret	= RtGetLastError();
			os_mem_data_free(ptr);
			break;
		}

		RtSetThreadPriority(thread->handle, data->priority);

		// Wait a bit for the thtread to run.

		for (i = 0; i < 100; i++)
		{
			if (thread->started)
				break;

			os_time_sleep_ms(10);
		}

		ret	= 0;
		break;
	}

	return(ret);
}



//*****************************************************************************
void os_thread_destroy(os_thread_t* thread)
{
	DWORD	dw;
	int		i;

	if (thread)
	{
		if (thread->handle)
		{
			thread->quit	= 1;

			for (i = 0; i < 100; i++)
			{
				dw	= RtResumeThread(thread->handle);
				os_time_sleep_ms(10);

				if (thread->done)
					break;
			}
		}

		memset(thread, 0, sizeof(os_thread_t));
	}
}


