// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_spinlock.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"

// NOTES:
//
//	RTX does not support a spin lock. Consequently we use a semaphore
//	instead and service interrupts in an Interrupt Service Thread.



/******************************************************************************
*
*	Function:	os_spinlock_create
*
*	Purpose:
*
*		Create a spin lock.
*
*	Arguments:
*
*		lock	The OS specific data type for the lock.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int os_spinlock_create(os_spinlock_t* lock)
{
	int	ret;

	if (lock)
	{
		// Create a semaphore.
		memset(lock, 0, sizeof(os_spinlock_t));
		ret	= os_sem_create(&lock->sem);

		if (ret)
			memset(lock, 0, sizeof(os_spinlock_t));
	}
	else
	{
		// The pointer is NULL.
		ret	= -EINVAL;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	os_spinlock_destroy
*
*	Purpose:
*
*		Destroy a spin lock.
*
*	Arguments:
*
*		lock	The OS specific data type for the lock.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void os_spinlock_destroy(os_spinlock_t* lock)
{
	if (lock)
	{
		os_sem_destroy(&lock->sem);
		memset(lock, 0, sizeof(os_spinlock_t));
	}
}



/******************************************************************************
*
*	Function:	os_spinlock_lock
*
*	Purpose:
*
*		Acquire a spin lock.
*
*	Arguments:
*
*		lock	The OS specific data type for the lock.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void os_spinlock_lock(os_spinlock_t* lock)
{
	if (lock)
		os_sem_lock(&lock->sem);
}



/******************************************************************************
*
*	Function:	os_spinlock_unlock
*
*	Purpose:
*
*		Release a spin lock.
*
*	Arguments:
*
*		lock	The OS specific data type for the lock.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void os_spinlock_unlock(os_spinlock_t* lock)
{
	if (lock)
		os_sem_unlock(&lock->sem);
}


