// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_service.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
static void _msg_close(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	int	ret;

	ret	= os_close(msg->u.close.dev_id);

	if (ret)
	{
		msg->ret		= ret;
		msg->status		= OS_MSG_STS_FAIL;
		msg->processed	= 1;
	}
	else
	{
		msg->ret		= 0;
		msg->status		= OS_MSG_STS_PASS;
		msg->processed	= 1;
	}
}



//*****************************************************************************
static void _msg_ioctl(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	void*	arg;
	int		ret;
	int		size;

	size	= OS_IOCTL_SIZE_DECODE(msg->u.ioctl.cmd);

	if (size == 0)
		arg	= (void*) msg->u.ioctl.val;
	else
		arg	= msg->u.ioctl.buf;

	ret	= os_ioctl(msg->u.ioctl.dev_id, msg->u.ioctl.cmd, arg);

	if (ret)
	{
		msg->ret		= ret;
		msg->status		= OS_MSG_STS_FAIL;
		msg->processed	= 1;
	}
	else
	{
		msg->ret		= 0;
		msg->status		= OS_MSG_STS_PASS;
		msg->processed	= 1;
	}
}



//*****************************************************************************
static void _msg_open(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	int	ret;

	ret	= os_open(msg->u.open.index, &msg->u.open.dev_id);

	if (ret < 0)
	{
		msg->ret		= ret;
		msg->status		= OS_MSG_STS_FAIL;
		msg->processed	= 1;
	}
	else
	{
		msg->ret		= 0;
		msg->status		= OS_MSG_STS_PASS;
		msg->processed	= 1;
	}
}



//*****************************************************************************
static void _msg_read(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	int	ret;

#ifndef DEV_SUPPORTS_READ

	char	buf[32];

	ret	= os_read(msg->u.read.dev_id, buf, sizeof(buf));

#else

	ret	= os_read(msg->u.read.dev_id, alt->rx.mem.ptr, msg->u.read.count);

#endif

	if (ret < 0)
		msg->status		= OS_MSG_STS_FAIL;
	else
		msg->status		= OS_MSG_STS_PASS;

	msg->ret		= ret;
	msg->processed	= 1;
}



//*****************************************************************************
static void _msg_write(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	int	ret;

#ifndef DEV_SUPPORTS_WRITE

	char	buf[32];

	memset(buf, 0, sizeof(buf));
	ret	= os_write(msg->u.write.dev_id, buf, sizeof(buf));

#else

	ret	= os_write(msg->u.write.dev_id, alt->tx.mem.ptr, msg->u.write.count);

#endif

	if (ret < 0)
		msg->status		= OS_MSG_STS_FAIL;
	else
		msg->status		= OS_MSG_STS_PASS;

	msg->ret		= ret;
	msg->processed	= 1;
}



//*****************************************************************************
static void _process_message(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	switch (msg->type)
	{
		default:

			msg->status	= OS_MSG_STS_MSG_TYPE;
			msg->ret	= -EINVAL;
			break;

		case OS_MSG_TYPE_CLOSE:	_msg_close(alt, msg);	break;
		case OS_MSG_TYPE_IOCTL:	_msg_ioctl(alt, msg);	break;
		case OS_MSG_TYPE_OPEN:	_msg_open(alt, msg);	break;
		case OS_MSG_TYPE_READ:	_msg_read(alt, msg);	break;
		case OS_MSG_TYPE_WRITE:	_msg_write(alt, msg);	break;
	}
}



//*****************************************************************************
static long _service_thread(void* arg)
{
	GSC_ALT_STRUCT_T*	alt;
	os_thread_data_t*	data;
	os_msg_entry_t*		entry;
	int					ret;

	data	= arg;
	alt		= data->alt;
	entry	= &alt->os.msg_list[data->index];

	for (;;)
	{
		ret	= os_sem_lock(&entry->to_dev);

		if (ret)
			break;

		if (entry->thread.quit == 0)
			_process_message(alt, entry->msg);

		os_sem_unlock(&entry->to_app);

		if (entry->thread.quit)
			break;
	}

	return(ret);
}



//*****************************************************************************
int os_service_thread_create(os_thread_data_t* data)
{
	int	ret;

	if (	(data)
		&&	(data->alt)
		&&	(data->index >= 0)
		&&	(data->index < OS_MSG_LIST_SIZE))
	{
		ret	= os_thread_create(
				&data->alt->os.msg_list[data->index].thread,
				_service_thread,
				data);
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}


