// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_sem.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
int os_sem_create(os_sem_t* sem)
{
	int	ret;

	ret	= os_sem_create_named(sem, NULL, 0);
	return(ret);
}



//*****************************************************************************
int os_sem_create_named(
	os_sem_t*	sem,	// Record the results here.
	const char*	name,	// Should be "DEVICE" or "DEVICE.X". Ignored if NULL.
	u32			suffix)	// The 8 hex digit suffix. Ignored if zero.
{
	char	buf[OS_RESOURCE_NAME_MAX_LEN];
	int		ret		= -EINVAL;

	if (sem)
	{
		// Create a new, one unit semaphore.
		memset(sem, 0, sizeof(os_sem_t));
		os_res_name_create(buf, sizeof(buf), name, "sem", suffix);

		if (name)
			name	= buf;

		if (name == NULL)
		{
			suffix	= os_res_get_suffix();
			sprintf(buf, "%s.sem.%08lX", DEV_NAME, (long) suffix);
			name	= buf;
		}

		sem->handle	= RtCreateSemaphore((void*) name, 1, 1, buf);

		if (sem->handle)
		{
			ret	= 0;
		}
		else
		{
			memset(sem, 0, sizeof(os_sem_t));
			ret	= -EINVAL;
		}
	}

	return(ret);
}



//*****************************************************************************
void os_sem_destroy(os_sem_t* sem)
{
	if (sem)
	{
		if (sem->handle)
			RtCloseHandle(sem->handle);

		memset(sem, 0, sizeof(os_sem_t));
	}
}



//*****************************************************************************
int os_sem_lock(os_sem_t* sem)
{
	DWORD	dw;
	int		ret;

	if ((sem) && (sem->handle))
	{
		// Gain access to the semaphore.
		dw	= RtWaitForSingleObject(sem->handle, INFINITE);
		ret	= (dw == WAIT_OBJECT_0) ? 0 : -ERESTARTSYS;
	}
	else
	{
		// The semaphore was never created.
		ret	= -EINVAL;
	}

	return(ret);
}



//*****************************************************************************
void os_sem_unlock(os_sem_t* sem)
{
	if ((sem) && (sem->handle))
		RtReleaseSemaphore(sem->handle, 1, NULL);
}


