// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_root.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include <stdio.h>

#include "main.h"



// variables ******************************************************************

static	dev_data_t	_dev;
static	os_mem_t	_mem;



//*****************************************************************************
static void _init_buffer(void)
{
	const char*	comma;
	int			i;
	char*		ptr	= _mem.ptr;

	sprintf(ptr,
			"version: %s\n"
			"boards: %d\n"
			"models: ",
			GSC_DRIVER_VERSION,
			gsc_global.dev_qty);
	comma	= "";

	for (i = 0; i < (int) ARRAY_ELEMENTS(gsc_global.dev_list); i++)
	{
		if (gsc_global.dev_list[i])
		{
			ptr	+= strlen(ptr);
			sprintf(ptr, "%s%s", comma, gsc_global.dev_list[i]->model);
			comma	= ",";
		}
	}

	ptr	+= strlen(ptr);
	strcat(ptr, "\n");

#if defined(DEV_SUPPORTS_PROC_ID_STR)

	// This is intended to accommodate board identification
	// for those that have user jumpers.
	ptr	+= strlen(ptr);
	sprintf(ptr, "ids: ");
	comma	= "";

	for (i = 0; i < (int) ARRAY_ELEMENTS(gsc_global.dev_list); i++)
	{
		if (gsc_global.dev_list[i])
		{
			ptr	+= strlen(ptr);
			sprintf(ptr,
					"%s%s",
					comma,
					gsc_global.dev_list[i]->proc_id_str);
			comma	= ",";
		}
	}

	ptr	+= strlen(ptr);
	strcat(ptr, "\n");
#endif
}



//*****************************************************************************
int os_root_close(void)
{
	return(0);
}



//*****************************************************************************
int os_root_ioctl(int cmd, void* arg)
{
	// Ioctl not supported.
    return(-EPERM);
}



//*****************************************************************************
int os_root_open(void)
{
	return(0);
}



//*****************************************************************************
int os_root_read(int count)
{
	int	bytes;
	int	ret;

	// We don't actually transfer any memory content, as the library has direct
	// access to our buffer and performs the copy there. Also, the actual
	// hardware device may not support reads, but the driver root device does.

	bytes	= strlen(_mem.ptr) + 1;

	if (count < 1)
	{
		ret	= 0;
	}
	else if (count > bytes)
	{
		ret	= bytes;
	}
	else
	{
		ret	= count;
	}

    return(ret);
}



//*****************************************************************************
int os_root_write(void)
{
	return(-EPERM);
}



//*****************************************************************************
int os_root_start(void)
{
	char*		ptr;
	int			ret;
	size_t		size	= 100 + MAX_DEV_QTY * 100;

	for (;;)	// A convenience loop.
	{
		// Initialize the data we'll return to readers.
		// Acquire memory for our buffer.
		ptr	= os_mem_dma_alloc(&size, &_mem);

		if (ptr == NULL)
		{
			ret	= -ENOMEM;
			break;
		}

		_init_buffer();

		// Perform pseudo device initialization.
		memset(&_dev, 0, sizeof(dev_data_t));

#if (GSC_DEVS_PER_BOARD <= 1)

		_dev.board_index	= -1;

#else

		for (ret = 0; ret < GSC_DEVS_PER_BOARD; ret++)
			_dev.channel[ret].dev_index	= ret ? -99 : -1;

#endif

		// Create the interface resources.
		ret	= os_res_create(&_dev);

		if (ret)
			break;

		// Add the Rx buffer.

#if (GSC_DEVS_PER_BOARD <= 1)
		_dev.os.main_mem.ptr->rx.adrs	= _mem.adrs;
		_dev.os.main_mem.ptr->rx.size	= _mem.bytes;

#if defined(DEV_SUPPORTS_READ)
		_dev.rx.mem	= _mem;
#endif

#else
		_dev.channel[0].os.main_mem.ptr->rx.adrs	= _mem.adrs;
		_dev.channel[0].os.main_mem.ptr->rx.size	= _mem.bytes;

#if defined(DEV_SUPPORTS_READ)
		_dev.channel[0].rx.mem	= _mem;
#endif

#endif


		// Start the primary thread.
		ret	= os_primary_thread_create(&_dev);
		break;
	}

	return(ret);
}



//*****************************************************************************
void os_root_stop(void)
{
	os_res_destroy(&_dev);
	os_mem_dma_free(&_mem);
}


