// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_reg.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
void os_reg_mem_mx_u8(dev_data_t* dev, VADDR_T va, u8 value, u8 mask)
{
	u8	reg;

	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		reg	= ((u8*) va)[0];
		reg	= (reg & ~mask) | (value & mask);
		((u8*) va)[0]	= reg;

		if (dev)
			gsc_irq_access_unlock(dev);
	}
}



//*****************************************************************************
void os_reg_mem_mx_u16(dev_data_t* dev, VADDR_T va, u16 value, u16 mask)
{
	u16	reg;

	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		reg	= ((u16*) va)[0];
		reg	= (reg & ~mask) | (value & mask);
		((u16*) va)[0]	= reg;

		if (dev)
			gsc_irq_access_unlock(dev);
	}
}



//*****************************************************************************
void os_reg_mem_mx_u32(dev_data_t* dev, VADDR_T va, u32 value, u32 mask)
{
	u32	reg;

	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		reg	= ((u32*) va)[0];
		reg	= (reg & ~mask) | (value & mask);
		((u32*) va)[0]	= reg;

		if (dev)
			gsc_irq_access_unlock(dev);
	}
}



//*****************************************************************************
u8 os_reg_mem_rx_u8(dev_data_t* dev, VADDR_T va)
{
	u8	value	= 0;

	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		value	= ((u8*) va)[0];

		if (dev)
			gsc_irq_access_unlock(dev);
	}

	return(value);
}



//*****************************************************************************
u16 os_reg_mem_rx_u16(dev_data_t* dev, VADDR_T va)
{
	u16	value	= 0;

	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		value	= ((u16*) va)[0];

		if (dev)
			gsc_irq_access_unlock(dev);
	}

	return(value);
}



//*****************************************************************************
u32 os_reg_mem_rx_u32(dev_data_t* dev, VADDR_T va)
{
	u32	value	= 0;

	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		value	= ((u32*) va)[0];

		if (dev)
			gsc_irq_access_unlock(dev);
	}

	return(value);
}



//*****************************************************************************
void os_reg_mem_tx_u8(dev_data_t* dev, VADDR_T va, u8 value)
{
	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		((u8*) va)[0]	= value;

		if (dev)
			gsc_irq_access_unlock(dev);
	}
}



//*****************************************************************************
void os_reg_mem_tx_u16(dev_data_t* dev, VADDR_T va, u16 value)
{
	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		((u16*) va)[0]	= value;

		if (dev)
			gsc_irq_access_unlock(dev);
	}
}



//*****************************************************************************
void os_reg_mem_tx_u32(dev_data_t* dev, VADDR_T va, u32 value)
{
	if (va)
	{
		if (dev)
			gsc_irq_access_lock(dev);

		((u32*) va)[0]	= value;

		if (dev)
			gsc_irq_access_unlock(dev);
	}
}



//*****************************************************************************
void os_reg_pci_mx_u8(dev_data_t* dev, os_pci_t* pci, u16 offset, u8 value, u8 mask)
{
	u8	reg;

	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtGetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &reg,
			offset,
			1);

		reg	= (reg & ~mask) | (value & mask);

		RtSetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &reg,
			offset,
			1);
	}

	if (dev)
		gsc_irq_access_unlock(dev);
}



//*****************************************************************************
void os_reg_pci_mx_u16(dev_data_t* dev, os_pci_t* pci, u16 offset, u16 value, u16 mask)
{
	u16	reg;

	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtGetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &reg,
			offset,
			2);

		reg	= (reg & ~mask) | (value & mask);

		RtSetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &reg,
			offset,
			2);
	}

	if (dev)
		gsc_irq_access_unlock(dev);
}



//*****************************************************************************
void os_reg_pci_mx_u32(dev_data_t* dev, os_pci_t* pci, u16 offset, u32 value, u32 mask)
{
	u32	reg;

	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtGetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &reg,
			offset,
			4);

		reg	= (reg & ~mask) | (value & mask);

		RtSetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &reg,
			offset,
			4);
	}

	if (dev)
		gsc_irq_access_unlock(dev);
}



//*****************************************************************************
u8 os_reg_pci_rx_u8(dev_data_t* dev, os_pci_t* pci, u16 offset)
{
	u8	value	= 0;

	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtGetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &value,
			offset,
			1);
	}

	if (dev)
		gsc_irq_access_unlock(dev);

	return(value);
}



//*****************************************************************************
u16 os_reg_pci_rx_u16(dev_data_t* dev, os_pci_t* pci, u16 offset)
{
	u16	value	= 0;

	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtGetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &value,
			offset,
			2);
	}

	if (dev)
		gsc_irq_access_unlock(dev);

	return(value);
}



//*****************************************************************************
u32 os_reg_pci_rx_u32(dev_data_t* dev, os_pci_t* pci, u16 offset)
{
	u32	value	= 0;

	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtGetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &value,
			offset,
			4);
	}

	if (dev)
		gsc_irq_access_unlock(dev);

	return(value);
}



//*****************************************************************************
void os_reg_pci_tx_u8(dev_data_t* dev, os_pci_t* pci, u16 offset, u8 value)
{
	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtSetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &value,
			offset,
			1);

	}

	if (dev)
		gsc_irq_access_unlock(dev);
}



//*****************************************************************************
void os_reg_pci_tx_u16(dev_data_t* dev, os_pci_t* pci, u16 offset, u16 value)
{
	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtSetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &value,
			offset,
			2);

	}

	if (dev)
		gsc_irq_access_unlock(dev);
}



//*****************************************************************************
void os_reg_pci_tx_u32(dev_data_t* dev, os_pci_t* pci, u16 offset, u32 value)
{
	if (dev)
		gsc_irq_access_lock(dev);

	if (pci)
	{
		RtSetBusDataByOffset(
			PCIConfiguration,
			dev->pci->BusNumber,
			dev->pci->SlotNumber,
			(void*) &value,
			offset,
			4);
	}

	if (dev)
		gsc_irq_access_unlock(dev);
}


