// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_primary.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
static void _msg_index_alloc(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	os_thread_data_t	data;
	int					i;
	int					ret;

	ret	= os_sem_lock(&alt->os.msg_mem.sem);

	if (ret)
	{
		msg->ret		= ret;
		msg->status		= OS_MSG_STS_FAIL;
		msg->processed	= 1;
	}
	else
	{
		msg->ret		= -ENOMEM;
		msg->status		= OS_MSG_STS_FAIL;

		for (i = 0; i < OS_MSG_LIST_SIZE; i++)
		{
			if (alt->os.msg_list[i].in_use)
				continue;

			if (alt->os.msg_list[i].thread.handle)
			{
				// This entry already has a service thread.
				break;
			}

			// Start a service thread for this entry.
			data.alt		= alt;
			data.index		= i;
			data.priority	= 124;
			ret				= os_service_thread_create(&data);

			if (ret)
			{
				// Try another table entry. (In otherwords, try again.)
				continue;
			}

			// The service thread started.
			break;
		}

		if (i < OS_MSG_LIST_SIZE)
		{
			alt->os.msg_list[i].in_use	= 1;
			msg->ret					= 0;
			msg->status					= OS_MSG_STS_PASS;
			msg->u.index_alloc.index	= i;
			msg->processed				= 1;
		}

		os_sem_unlock(&alt->os.msg_mem.sem);
	}
}



//*****************************************************************************
static void _msg_index_free(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	int	i;
	int	ret;

	ret	= os_sem_lock(&alt->os.msg_mem.sem);

	if (ret)
	{
		msg->ret		= ret;
		msg->status		= OS_MSG_STS_FAIL;
		msg->processed	= 1;
	}
	else
	{
		i	= msg->u.index_free.index;

		if (alt->os.msg_list[i].in_use)
		{
			alt->os.msg_list[i].in_use	= 0;
			msg->ret					= 0;
			msg->status					= OS_MSG_STS_PASS;
		}
		else
		{
			msg->ret					= -EINVAL;
			msg->status					= OS_MSG_STS_FAIL;
		}

		msg->processed	= 1;
		os_sem_unlock(&alt->os.msg_mem.sem);
	}
}



//*****************************************************************************
static void _process_message(GSC_ALT_STRUCT_T* alt, os_msg_t* msg)
{
	switch (msg->type)
	{
		default:

			msg->status	= OS_MSG_STS_MSG_TYPE;
			msg->ret	= -EINVAL;
			break;

		case OS_MSG_TYPE_INDEX_ALLOC:	_msg_index_alloc(alt, msg);	break;
		case OS_MSG_TYPE_INDEX_FREE:	_msg_index_free(alt, msg);	break;
	}
}



//*****************************************************************************
static long _primary_thread(void* arg)
{
	GSC_ALT_STRUCT_T*	alt;
	os_thread_data_t*	data;
	os_msg_entry_t*		entry;
	int					ret;


	data	= arg;
	alt		= data->alt;
	entry	= &alt->os.primary;

	for (;;)
	{
		ret	= os_sem_lock(&entry->to_dev);

		if (ret)
			break;

		if (entry->thread.quit == 0)
			_process_message(alt, entry->msg);

		os_sem_unlock(&entry->to_app);

		if (entry->thread.quit)
			break;
	}

	return(ret);
}



//*****************************************************************************
int os_primary_thread_create(dev_data_t* dev)
{
	int					ret;
	os_thread_data_t	thread;

#if (GSC_DEVS_PER_BOARD <= 1)

	if (dev->board_index >= -1)
	{
		memset(&thread, 0, sizeof(os_thread_data_t));
		thread.alt		= dev;
		thread.index	= 0;	// This field is for service threads.
		thread.priority	= 125;
		ret	= os_thread_create(
				&alt->os.primary.thread,
				_primary_thread,
				&thread);
	}

#else

	{
		int	i;
		int	tmp;

		ret	= 0;

		for (i = 0; i < GSC_DEVS_PER_BOARD; i++)
		{
			if (dev->channel[i].dev_index < -1)
				continue;

			memset(&thread, 0, sizeof(os_thread_data_t));
			thread.alt		= &dev->channel[i];
			thread.index	= 0;	// This field is for service threads.
			thread.priority	= 125;
			tmp	= os_thread_create(
					&dev->channel[i].os.primary.thread,
					_primary_thread,
					&thread);
			ret	= ret ? ret : tmp;
		}
	}

#endif

	return(ret);
}


