// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_pci.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
void os_pci_clear_master(os_pci_t* pci)
{
	// Clear the Master Enable bit.

	if ((pci) && (pci->dev))
		os_reg_pci_mx_u8(pci->dev, pci, 4, 0, D2);
}



//*****************************************************************************
int os_pci_dev_enable(os_pci_t* pci)
{
	// Not required in RTX.
	return(0);
}



//*****************************************************************************
void os_pci_dev_disable(os_pci_t* pci)
{
	// Not required in RTX.
}



//*****************************************************************************
int os_pci_set_master(os_pci_t* pci)
{
	// Clear the Master Enable bit.

	if ((pci) && (pci->dev))
		os_reg_pci_mx_u8(pci->dev, pci, 4, D2, D2);

	return(0);
}



//*****************************************************************************
void os_pci_enum_init(os_pci_enum_t* pcie)
{
	if (pcie)
	{
		memset(pcie, 0, sizeof(os_pci_enum_t));
		pcie->func_no	= -1;
	}
}



//*****************************************************************************
int os_pci_enum_next(os_pci_enum_t* pcie)
{
	int				found	= 0;	// status returned
	int				got;
	PCI_SLOT_NUMBER	slot;
	u16				vid;

	for (; pcie;)	// loop for bus, device and function
	{
		pcie->func_no++;

		if (pcie->func_no >= PCI_MAX_FUNCTION)
		{
			pcie->func_no	= 0;
			pcie->dev_no++;
		}

		if (pcie->dev_no >= PCI_MAX_DEVICES)
		{
			pcie->dev_no	= 0;
			pcie->bus_no++;
		}

		if (pcie->bus_no >= 256)
			break;

		slot.u.bits.Reserved		= 0;
		slot.u.bits.DeviceNumber	= pcie->dev_no;
		slot.u.bits.FunctionNumber	= pcie->func_no;

		// Find out if a device is at this location.
		got	= RtGetBusDataByOffset(
				PCIConfiguration,
				pcie->bus_no,
				slot.u.AsULONG,
				&vid,
				0,
				sizeof(vid));

		if (got == 0)
		{
			// There are no PCI busses left to look at.
			break;
		}

		if (vid == PCI_INVALID_VENDORID)
		{
			// There isn't a device at this location.
			continue;
		}

		// A device is present at this location.
		pcie->BusNumber		= pcie->bus_no;
		pcie->SlotNumber	= slot.u.AsULONG;
		found	= 1;
		break;
	}

	return(found);
}


