// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_open.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
int os_open(int index, s32* dev_id)
{
	GSC_ALT_STRUCT_T*	alt		= NULL;
	int					board	= index;
	int					channel	= 0;
	int					ret;

	for (;;)	// A convenience loop.
	{
		if (index < -1)
		{
			ret	= -EINVAL;
			break;
		}

		if (dev_id == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		if (index == -1)
		{
			ret			= os_root_open();
			dev_id[0]	= index;
			break;
		}

#if (GSC_DEVS_PER_BOARD > 1)

		board	= index / GSC_DEVS_PER_BOARD;
		channel	= index % GSC_DEVS_PER_BOARD;

		if (board >= ARRAY_ELEMENTS(gsc_global.dev_list))
		{
			ret	= -EINVAL;
			break;
		}

		alt	= &gsc_global.dev_list[board]->channel[channel];

#else

		if (index >= ARRAY_ELEMENTS(gsc_global.dev_list))
		{
			ret	= -EINVAL;
			break;
		}

		alt	= gsc_global.dev_list[index];

#endif

		if (alt == NULL)
		{
			// The referenced device doesn't exist.
			ret	= -ENODEV;
			break;
		}

		ret			= gsc_open(alt);
		dev_id[0]	= index;
		break;
	}

	return(ret);
}


