// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_mem.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
void* os_mem_data_alloc(size_t size)
{
	void*	ptr;

	if (size == 0)
	{
		ptr	= NULL;
	}
	else
	{
		ptr	= RtAllocateLockedMemory(size);

		if (ptr == NULL)
			printf("%s: os_mem_data_alloc(%ld) failed.\n", DEV_NAME, (long) size);
	}

	return(ptr);
}



//*****************************************************************************
void* os_mem_data_alloc_named(
	size_t		size,	// Allocate this amount of memory.
	os_mem_t*	mem,	// Record the results here.
	int			rw,		// Give other processes read/write access?
	const char*	name,	// Should be "DEVICE" or "DEVICE.X". Ignored if NULL.
	u32			suffix)	// The 8 hex digit suffix. Ignored if zero.
{
	char	buf[OS_RESOURCE_NAME_MAX_LEN];
	HANDLE	handle;
	void*	ptr;

	if (size == 0)
	{
		// There is nothing to allocate.
		ptr	= NULL;
	}
	else if (mem == NULL)
	{
		// The pointer is NULL.
		ptr	= NULL;
	}
	else
	{
		// Allocate sharred memory.
		memset(mem, 0, sizeof(os_mem_t));
		os_res_name_create(buf, sizeof(buf), name, "mem", suffix);
		handle	= RtCreateSharedMemory(0, 0, size, buf, &ptr);

		if ((handle) && (ptr))
		{
			mem->handle	= handle;
			mem->adrs	= 0;
			mem->ptr	= ptr;
			mem->bytes	= size;
		}
		else
		{
			memset(mem, 0, sizeof(os_mem_t));
			ptr	= NULL;
			printf(	"%s: os_mem_data_alloc_named(%ld) failed ('%s').\n",
					DEV_NAME,
					(long) size,\
					name ? name : "unnamed");
		}
	}

	return(ptr);
}



//*****************************************************************************
void os_mem_data_free(void* ptr)
{
	if (ptr)
		RtFreeLockedMemory(ptr);
}



//*****************************************************************************
void os_mem_data_free_named(os_mem_t* mem)
{
	if (mem)
	{
		if (mem->handle)
			CloseHandle(mem->handle);

		memset(mem, 0, sizeof(os_mem_t));
	}
}



//*****************************************************************************
void* os_mem_dma_alloc(size_t* bytes, os_mem_t* mem)
{
	LARGE_INTEGER	adrs;
	LARGE_INTEGER	bound;
	LARGE_INTEGER	high;
	LARGE_INTEGER	low;
	size_t			min	= 4096;
	void*			ptr;

	if (bytes == NULL)
	{
		// No memory being allocated.
		ptr	= NULL;
	}
	else if (bytes[0] < 1)
	{
		// No memory being allocated.
		ptr	= NULL;
	}
	else if (mem == NULL)
	{
		// The pointer is invalid.
		ptr	= NULL;
	}
	else
	{
		memset(mem, 0, sizeof(os_mem_t));
		low.QuadPart	= 0;
		high.QuadPart	= 0xFFFFFFFF;
		bound.QuadPart	= 0;

		if (bytes[0] < min)
			bytes[0]	= min;

		for (;;)
		{
			ptr	= RtAllocateContiguousMemorySpecifyCache(
					bytes[0],
					low,
					high,
					bound,
					MmNonCached);

			if (ptr)
			{
				adrs		= RtGetPhysicalAddress(ptr);
				mem->ptr	= ptr;
				mem->bytes	= bytes[0];
				mem->adrs	= (unsigned long) adrs.QuadPart;
				break;
			}

			bytes[0]	= (bytes[0] + 4095) & ~4095;	// Round up to 4K
			bytes[0]	-= 4096;

			if (bytes[0] <= min)
			{
				// The request could not be satisified.
				printf("%s: os_mem_dma_alloc(%ld) failed.\n", DEV_NAME, (long) bytes[0]);
				break;
			}
		}
	}

	return(ptr);
}



//*****************************************************************************
void os_mem_dma_free(os_mem_t* mem)
{
	if (mem)
	{
		if (mem->ptr)
			RtFreeContiguousMemory(mem->ptr);

		memset(mem, 0, sizeof(os_mem_t));
	}
}



//*****************************************************************************
int os_mem_copy_from_user_ioctl(void* dst, const void* src, long size)
{
	int	ret;

	if ((dst) && (src))
	{
		memcpy(dst, src, size);
		ret	= 0;
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}



//*****************************************************************************
int os_mem_copy_from_user_tx(void* dst, const void* src, long size)
{
	// No copying is performed here. It is done by the application level
	// library. It is done this way as the library has direct access to our I/O
	// buffer and we have no access to the user buffer.
	return(0);
}



//*****************************************************************************
int os_mem_copy_to_user_ioctl(void* dst, const void* src, long size)
{
	int	ret;

	if ((dst) && (src))
	{
		memcpy(dst, src, size);
		ret	= 0;
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}


//*****************************************************************************
int os_mem_copy_to_user_rx(void* dst, const void* src, long size)
{
	// No copying is performed here. It is done by the application level
	// library. It is done this way as the library has direct access to our I/O
	// buffer and we have no access to the user buffer.
	return(0);
}


