// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_lib.h $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module
// This defines the interface to the RTSS device driver that is used by
// .rtss and .exe executables.

#ifndef __OS_LIB_H__
#define __OS_LIB_H__



// #defines *******************************************************************

#define	OS_MSG_STS_PASS					0
#define	OS_MSG_STS_FAIL					1
#define	OS_MSG_STS_MSG_TYPE				2

#define	OS_RESOURCE_NAME_MAX_LEN		64	// including NULL terminator

#define	OS_MSG_LIST_SIZE				128	// maximum size

#define	OS_MSG_TYPE_CLOSE				1
#define	OS_MSG_TYPE_IOCTL				2
#define	OS_MSG_TYPE_OPEN				3
#define	OS_MSG_TYPE_READ				4
#define	OS_MSG_TYPE_WRITE				5
#define	OS_MSG_TYPE_INDEX_ALLOC			6
#define	OS_MSG_TYPE_INDEX_FREE			7



// data types *****************************************************************

typedef struct
{
	// Each memory resource containing this structure is named for the device
	// and index being accessed (i.e. "sio4.2"). There is one such named
	// resource for each device (or channel) recognized by the driver. This
	// structure is the means by which the driver makes each device accessible.
	// All other resources for the referenced device are named for the device,
	// the resource type, and an eight character hexadecimal suffic (i.e.
	// "sio4.mem.00001AD3"). The 32-bit suffix numbers are contained within
	// this structure so that the resource names can be derived and accessed by
	// the library.

	u32					size;		// Structure size in bytes.

	struct
	{
		u32				xfer;		// suffix of primary xfer semaphore name
		u32				to_dev;		// suffix of primary to_dev semaphore name
		u32				to_app;		// suffix of primary to_app semaphore name
		u32				mem;		// suffix of primary message memory name
									// This memory is for a single message.
	} primary;

	struct
	{
		u32				mem;		// suffix of regular message memory name
									// This refers to a block of memory that
									// contains OS_MSG_LIST_SIZE number of
									// os_msg_t structures.
	} msg_mem;

	struct
	{
		u32				xfer;		// suffix of service xfer semaphore name
		u32				to_dev;		// suffix of service to_dev semaphore name
		u32				to_app;		// suffix of service to_app semaphore name
	} msg_list[OS_MSG_LIST_SIZE];

	struct
	{
		// For now it is assumed to be 32-bit addressible.
		u32				adrs;		// physical address of the driver's Rx buffer
									// This is 32-bits as the current DMA engine
									// is limited to 32-bit DMA addresses.
		u32				size;		// size of the driver's Rx buffer
	} rx;

	struct
	{
		// For now it is assumed to be 32-bit addressible.
		u32				adrs;		// physical address of the driver's Tx buffer
									// This is 32-bits as the current DMA engine
									// is limited to 32-bit DMA addresses.
		u32				size;		// size of the driver's Tx buffer
	} tx;

} os_main_mem_t;

typedef struct
{
	u8					type;
	u8					status;
	u8					processed;
	u8					reserved;
	s32					ret;

	union
	{
		struct
		{
			u8			index;	// Returned by the driver.
								// This the index of the driver resource pool
								// entry the library can use for to transfer a
								// message.
		} index_alloc;

		struct
		{
			u8			index;	// Returned to the driver.
								// The library no longer needs this pool entry.
		} index_free;

		struct
		{
			s32			dev_id;	// The request is for the device with this id value.
		} close;

		struct
		{
			s32			dev_id;	// The request is for the device with this id value.
			s32			cmd;
			s32			val;	// Used when "arg" is not a pointer.
			u8			buf[512];
		} ioctl;

		struct
		{
			s32			index;	// The library wants access to this device.
			s32			dev_id;	// The library is to use this device id value
								// for all subsequent communication to the
								// referenced device.
		} open;

		struct
		{
			s32			dev_id;	// The request is for the device with this id value.
			s32			count;	// Please retrieve this amount of data.
		} read;

		struct
		{
			s32			dev_id;	// The request is for the device with this id value.
			s32			count;	// Please send this amount of data.
		} write;

	} u;

} os_msg_t;



// prototypes *****************************************************************



#endif
