// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_irq.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"

// NOTES:
//
//	RTX does not support a spin loop. As a locking mechanism is still
//	required we use a semaphore and service interrupts in an Interrupt
//	Service Thread.



//*****************************************************************************
#ifndef GSC_IRQ_NOT_USED
static BOOLEAN __stdcall _ist_handler(PVOID context)
{
	int		is_ours;
	BOOLEAN	ret;

	is_ours	= gsc_irq_isr_common(context, GSC_IRQ_ISR_FLAG_LOCK);
	ret		= is_ours ? TRUE : FALSE;
	return(ret);
}
#endif



//*****************************************************************************
#ifndef GSC_IRQ_NOT_USED
static INTERRUPT_DISPOSITION RTAPI _irq_isr(PVOID context)
{
	dev_data_t*				dev;
	int						is_ours;
	INTERRUPT_DISPOSITION	ret;

	dev		= (void*) context;
	is_ours	= gsc_irq_isr_common(context, GSC_IRQ_ISR_FLAG_DETECT_ONLY);
	ret		= is_ours ? CallInterruptThread : PassToNextDevice;
	return(ret);
}
#endif



//*****************************************************************************
#ifndef GSC_IRQ_NOT_USED
int os_irq_acquire(dev_data_t* dev)
{
	ATTACH_INTERRUPT_PARAMETERS	parm;
	int							ret		= 0;
	PCI_SLOT_NUMBER				slot;

	if (dev->irq.irq.allotted == 0)
	{
		dev->irq.irq.irq_line	= os_reg_pci_rx_u8(dev, dev->pci, 0x3C);
		slot.u.AsULONG			= dev->pci->SlotNumber;

		parm.AttachVersion					= ATTACH_LINE_BASED;
		parm.LineBased.pThreadAttributes	= NULL;
		parm.LineBased.StackSize			= 0;
		parm.LineBased.pRoutine				= _ist_handler;
		parm.LineBased.Context				= dev;
		parm.LineBased.Priority				= 127;
		parm.LineBased.InterfaceType		= PCIBus;
		parm.LineBased.BusNumber			= dev->pci->BusNumber;
		parm.LineBased.SlotNumber			= slot;
		parm.LineBased.BusInterruptLevel	= dev->irq.irq.irq_line;
		parm.LineBased.BusInterruptVector	= dev->irq.irq.irq_line;
		parm.LineBased.Shared				= TRUE;
		parm.LineBased.InterruptMode		= LevelSensitive;
		parm.LineBased.MyInterrupt			= _irq_isr;
		parm.LineBased.ProcessorEnableMask	= 1 << RtGetCurrentProcessorNumber();
		dev->irq.irq.handle					= RtAttachInterrupt(&parm);

		if (dev->irq.irq.handle)
			dev->irq.irq.allotted	= 1;
		else
			ret	= RtGetLastError();
	}

	return(ret);
}
#endif



//*****************************************************************************
#ifndef GSC_IRQ_NOT_USED
void os_irq_release(dev_data_t* dev)
{
	if (dev->irq.irq.allotted)
	{
		RtReleaseInterrupt(dev->irq.irq.handle);
		dev->irq.irq.handle		= 0;
		dev->irq.irq.allotted	= 0;
	}
}
#endif


