// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_ioctl.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
int os_ioctl(int dev_id, int cmd, void* arg)
{
	GSC_ALT_STRUCT_T*	alt		= NULL;
	int					board	= dev_id;
	int					channel	= 0;
	int					ret;

	for (;;)	// A convenience loop.
	{
		if (dev_id == -1)
		{
			ret	= os_root_ioctl(cmd, arg);
			break;
		}

		if (dev_id < 0)
		{
			ret	= -EINVAL;
			break;
		}

#if (GSC_DEVS_PER_BOARD > 1)

		board	= dev_id / GSC_DEVS_PER_BOARD;
		channel	= dev_id % GSC_DEVS_PER_BOARD;

		if (board >= ARRAY_ELEMENTS(gsc_global.dev_list))
		{
			ret	= -EINVAL;
			break;
		}

		alt	= &gsc_global.dev_list[board]->channel[channel];

#else

		if (dev_id >= ARRAY_ELEMENTS(gsc_global.dev_list))
		{
			ret	= -EINVAL;
			break;
		}

		alt	= gsc_global.dev_list[dev_id];

#endif

		if (alt == NULL)
		{
			// The referenced device doesn't exist.
			ret	= -ENODEV;
			break;
		}

		ret	= gsc_ioctl(alt, cmd, arg);
		break;
	}

	return(ret);
}


