// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/rtx/os_event.c $
// $Rev: 33965 $
// $Date: 2015-11-05 18:24:19 -0600 (Thu, 05 Nov 2015) $

// RTX driver module

#include "main.h"



//*****************************************************************************
void os_event_create(os_event_t* evnt)
{
	if (evnt)
	{
		memset(evnt, 0, sizeof(os_event_t));
		evnt->handle	= RtCreateEvent(NULL, 1, FALSE, NULL);
	}
}



//*****************************************************************************
void os_event_destroy(os_event_t* evnt)
{
	if (evnt)
	{
		if (evnt->handle)
		{
			RtPulseEvent(evnt->handle);
			RtCloseHandle(evnt->handle);
		}

		memset(evnt, 0, sizeof(os_event_t));
	}
}



//*****************************************************************************
void os_event_resume(os_event_t* evnt)
{
	if ((evnt) && (evnt->handle))
	{
		RtPulseEvent(evnt->handle);
		RtResetEvent(evnt->handle);
	}
}



//*****************************************************************************
void os_event_wait(os_event_t* evnt, os_time_tick_t timeout)
{
	long	ms;

	if ((evnt) && (evnt->handle))
	{
		ms	= os_time_ticks_to_ms(timeout);

		if (ms < 1)
			ms	= 1;

		RtWaitForSingleObject(evnt->handle, ms);
	}
}


