// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/mp_fixed.c $
// $Rev: 31815 $
// $Date: 2015-06-09 12:24:11 -0500 (Tue, 09 Jun 2015) $

#include "main.h"



//*****************************************************************************
int mp_fixed_select(chan_data_t* chan, s32* prot)
{
	static const s32	list[16]	=
	{
		SIO4_XCVR_PROTOCOL_RS422_RS485,		// 0
		SIO4_XCVR_PROTOCOL_RS423,			// 1
		SIO4_XCVR_PROTOCOL_RS232,			// 2
		SIO4_XCVR_PROTOCOL_UNKNOWN,			// 3
		SIO4_XCVR_PROTOCOL_RS530,			// 4
		SIO4_XCVR_PROTOCOL_RS530A,			// 5
		SIO4_XCVR_PROTOCOL_V35,				// 6
		SIO4_XCVR_PROTOCOL_V35A,			// 7
		SIO4_XCVR_PROTOCOL_RS422_RS423_1,	// 8
		SIO4_XCVR_PROTOCOL_RS422_RS423_2,	// 9
		SIO4_XCVR_PROTOCOL_UNKNOWN,			// 10
		SIO4_XCVR_PROTOCOL_UNKNOWN,			// 11
		SIO4_XCVR_PROTOCOL_UNKNOWN,			// 12
		SIO4_XCVR_PROTOCOL_UNKNOWN,			// 13
		SIO4_XCVR_PROTOCOL_UNKNOWN,			// 14
		SIO4_XCVR_PROTOCOL_DISABLE			// 15
	};

	u32	psrcr;
	int	ret;

	switch (prot[0])
	{
		default:

			ret	= -EINVAL;
			break;

		case -1:

			psrcr	= os_reg_mem_rx_u32(chan->dev, chan->vaddr.gsc_psrcr_32);
			prot[0]	= GSC_FIELD_DECODE(psrcr, 27, 24);
			prot[0]	= list[prot[0]];
			ret		= 0;
			break;

		case SIO4_XCVR_PROTOCOL_DISABLE:
		case SIO4_XCVR_PROTOCOL_RS232:
		case SIO4_XCVR_PROTOCOL_RS422_RS423_1:
		case SIO4_XCVR_PROTOCOL_RS422_RS423_2:
		case SIO4_XCVR_PROTOCOL_RS422_RS485:
		case SIO4_XCVR_PROTOCOL_RS423:
		case SIO4_XCVR_PROTOCOL_RS530:
		case SIO4_XCVR_PROTOCOL_RS530A:
		case SIO4_XCVR_PROTOCOL_V35:
		case SIO4_XCVR_PROTOCOL_V35A:

			ret	= 0;
			break;
	}

	return(ret);
}


