// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/mp.c $
// $Rev: 18187 $
// $Date: 2012-09-26 17:07:43 -0500 (Wed, 26 Sep 2012) $

#include "main.h"



//*****************************************************************************
void mp_close(chan_data_t* chan)
{
	s32	proto	= SIO4_XCVR_PROTOCOL_DISABLE;

	mp_select_ioctl(chan, &proto);
}



//*****************************************************************************
int mp_init(chan_data_t* chan)
{
	s32	proto	= SIO4_XCVR_PROTOCOL_DISABLE;
	int	ret;

	ret	= mp_select_ioctl(chan, &proto);
	return(ret);
}



//*****************************************************************************
void mp_open(chan_data_t* chan)
{
	s32	proto	= SIO4_XCVR_PROTOCOL_DISABLE;

	mp_select_ioctl(chan, &proto);
}



//*****************************************************************************
int mp_select_ioctl(chan_data_t* chan, s32* arg)
{
	int	ret;

	switch (chan->dev->cache.mp_chip)
	{
		default:					ret	= mp_unknown_select(chan, arg);	break;
		case SIO4_MP_CHIP_FIXED:	ret	= mp_fixed_select(chan, arg);	break;
		case SIO4_MP_CHIP_SP508:	ret	= mp_sp508_select(chan, arg);	break;
	}

	return(ret);
}


