// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/main.h $
// $Rev: 33968 $
// $Date: 2015-11-05 18:47:39 -0600 (Thu, 05 Nov 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#include "sio4.h"

#include "gsc_common.h"

#define	DEV_BAR_SHOW						0
#define	DEV_DMA_CHAN_SETUP(alt,dma,dpr)		dev_dma_chan_setup((alt),(dma),(dpr))
#define	DEV_PCI_ID_SHOW						0
#define	GSC_DEVS_PER_BOARD					4
#define	GSC_ALT_DEV_GET(a)					(a)->dev
#define	GSC_ALT_STRUCT_GET(i,d)				gsc_alt_struct_get((i),(d))
#define	GSC_ALT_STRUCT_T					chan_data_t
typedef struct _chan_data_t					chan_data_t;

#include "gsc_main.h"

#include "mp.h"
#include "mp_fixed.h"
#include "mp_sp508.h"
#include "mp_unknown.h"

#include "osc.h"
#include "osc_cy22393.h"
#include "osc_cy22393_sio4.h"
#include "osc_fixed.h"
#include "osc_idc2053b_sio4.h"
#include "osc_unknown.h"



// #defines *******************************************************************

#define	DEV_MODEL							"SIO4"	// Upper case form of the below.
#define	DEV_NAME							"sio4"	// MUST AGREE WITH AISS8AO4_BASE_NAME

#define DEV_VERSION							"3.1"	// FOR DEVICE SPECIFIC CODE ONLY!
// 3.1	Corrected device index numbering to begin at zero.
//		Changes the wait event user argument to a void* type.
//		Added os_data_t to the device and channel structures.
//		Changes the I/O routines to pass around an os_mem_t structure rather than a buffer pointer.
//		Updated some tick usage code to account for extremely high tick rates.// 3.1	Simplified some error messages.
//		Updated per changes to access PCI registers.
// 3.0	Updated to use the newer common driver sources.
//		Updated the dev_read_startup() service.
//		Removed Linux specific content from non-Linux specific source files.
//		White space cleanup.
//		Now using a spinlock rather than enabling and disabling interrupts.
//		Migrated dev_irq_open()/close() to gsc_irq_open()/close().
//		Updated gsc_dma_open() and gsc_dma_close().
//		Made correction to some legacy cable macros.
// 2.8	Changed "isoch" text to "isoc", lower and upper case.
//		Made minor improvement in ISR code.
// 2.7	Additional LINTing.
// 2.6	Additional INTime porting.
//		Interrupts are handled before awaiting threads are resumed.
// 2.5	Reduced #include list in driver interface header.
//		Updated some feature detection code.
//		Corrected a FIFO size initialization bug.
//		Added the SIO4_QUERY_FW_TYPE_CONFIG query option.
//		Made some feature options channel specific vs board specific.
//		Fixed a bug in the Initialize IOCTL code.
// 2.4	LINTing for INtime.
// 2.3	Corrected the user jumper sense for the CPIe4-SIO8BX2.
//		Cleaned up white space and comments.
//		Linted the sources.
//		Updated the bus width support calculations.
//		Updated the transceiver support calculations.
//		Updated the FIFO Size Register and FIFO Count Register support calculation.
//		Made a correction in the CY22393 oscillator resource reuse code.
//		The ISR disables Non-USC IRQs if their status bit stays set when cleared.
//		Unused bits are cleared when writing to the ICR.
//		The IELR and the IHLR are written to only if they exist.
// 2.2	Added support for the XMC-SIO4BXR.
//		Fixed a service bug: SIO4_IOCTL_USC_HDLC_TX_UNDERRUN
//		Set the valid programming request range for IDC2053B to 1M to 20M.
//		Removed warning from strict compilation using sio4.h.
//		Fixed bug in SIO4_IOCTL_USC_CTS_CFG.
//		Fixed bug in SIO4_IOCTL_USC_DCD_CFG.
//		Fixed bug in PSRCR Bits determination.
//		Oscillator programming now returns the computed value.
//		The oscillator reference frequency is fixed for the CY22393.
//		Fixed a bug in the CY22393 oscillator programming code.
//		Fixed a bug in the CY22393 oscillator measurement code.
// 2.1	Fixed a bug in _arg_reg_mask() from ioctl.c.
//		Renamed and added some IOCTL services.
//		Updated and improved the ISR.
// 2.0	Overhauled the driver and interface.
//		This driver uses the multi-os common source tree.

#define	DEV_SUPPORTS_PROC_ID_STR
#define	DEV_SUPPORTS_READ
#define	DEV_SUPPORTS_WRITE
#define	DEV_WAIT_GSC_ALL					SIO4_WAIT_GSC_ALL
#define	DEV_WAIT_ALT_ALL					SIO4_WAIT_ALT_ALL

#define	GSC_REG_ENCODE_MASK					0xE000FFFF	// We use bits 16 through 28.
#define	GSC_READ_PIO_WORK_8_BIT
#define	GSC_WRITE_PIO_WORK_8_BIT

#define	OSC_FREQ_REF_DEFAULT				20000000L

// I/O services
#define	DEV_PIO_READ_AVAILABLE				pio_read_available
#define	DEV_PIO_READ_WORK					gsc_read_pio_work_8_bit
#define	DEV_DMA_READ_AVAILABLE				dma_read_available
#define	DEV_DMA_READ_WORK					dma_read_work
#define	DEV_DMDMA_READ_AVAILABLE			dmdma_read_available
#define	DEV_DMDMA_READ_WORK					dmdma_read_work

#define	DEV_PIO_WRITE_AVAILABLE				pio_write_available
#define	DEV_PIO_WRITE_WORK					gsc_write_pio_work_8_bit
#define	DEV_DMA_WRITE_AVAILABLE				dma_write_available
#define	DEV_DMA_WRITE_WORK					dma_write_work
#define	DEV_DMDMA_WRITE_AVAILABLE			dmdma_write_available
#define	DEV_DMDMA_WRITE_WORK				dmdma_write_work

#define SIO4_FW_TYPE_CONFIG_SYNC			0x04	// temporary until IOCTL service is added
#define SIO4_FW_TYPE_CONFIG_Z16C30			0x01



// data types *****************************************************************

struct _dev_io_t
{
	os_sem_t			sem;				// Only one Tx or Rx at a time.

	int					abort;
	size_t				bytes_per_sample;	// Sample size in bytes.
	gsc_dma_ch_t*		dma_channel;		// Use this channel for DMA.
	u32					dmdma_dir;			// DMDMA Direction for BCR.
	s32					io_mode;			// PIO, DMA, DMDMA
	s32					io_overrun_check;	// Check for overrun before doing I/O?
	u32					io_reg_offset;		// Offset of board's I/O FIFO.
	VADDR_T				io_reg_vaddr;		// Address of board's I/O FIFO.
	os_mem_t			mem;				// I/O buffer.
	s32					io_underrun_check;	// Check for underrun before doing I/O?
	int					non_blocking;		// Is this non-blocking I/O?
	s32					pio_threshold;		// Use PIO if samples <= this.
	s32					timeout_s;			// I/O timeout in seconds.
};

struct _chan_data_t
{
	os_sem_t			sem;		// control process access
	os_data_t			os;			// OS specific data for each device/channel
	struct _dev_data_t*	dev;
	int					in_use;		// Already in use (opened)?
	int					index;		// 0-3
	int					dev_index;	// 0-3, 4-7, ...

	dev_io_t			rx;
	dev_io_t			tx;

	gsc_wait_node_t*	wait_list;

	struct
	{
		#define	RCC_FIFO_SIZE				256

		// This is a software expansion to the USC's RCC FIFO.

		s32		enabled;
		s32		push;			// For putting data into the below fifo.
		s32		pull;			// For taking data from the below fifo.
		u32		fifo[RCC_FIFO_SIZE];
	} rcc_fifo;

	struct
	{
		s32		fifo_size_rx;	// Rx FIFO Size
		s32		fifo_size_tx;	// Tx FIFO Size

		u32		gsc_fsr_32;		// FIFO Size Register value

		s32		mp;				// Multi-Protocol Xcvr fw?
		u32		mp_bitmap;		// Corresponds to SP508 protocols (i.e. 1 << x)
		s32		mp_program;		// Can we program changes?

		s32		reg_ccr;		// Clock Control Register: Supported?
		s32		reg_gpiosr;		// GPIO Source Register: Supported?
		s32		reg_psrcr;		// Pin Source Register: Supported?
		u32		reg_psrcr_bits;	// Which PSRCR bits are supported.
		s32		reg_pstsr;		// Pin Status Register: Supported?
		u32		reg_pstsr_bits;	// Which PSTSR bits are supported.
		s32		reg_rcr;		// Rx Count Register: Supported?
		s32		reg_sbr;		// Sync Byte Register: Supported?
		s32		reg_tcr;		// Tx Count Register: Supported?
		s32		tx_fifo_empty_cfg;// CSR D18/D26: Tx Disable on FIFO Empty?
		s32		rx_fifo_full_cfg_chan;	// CSR D19: Rx FIFO Stop On Full? Channel Specific
		s32		rx_fifo_overrun;// CSR D16: Rx FIFO Overrun?
		s32		rx_status_word;	// CSR D3: Rx Status Word Enable?

	} cache;

	struct
	{
		VADDR_T	gsc_csr_32;		// Command/Status Reg
		VADDR_T	gsc_fcr_32;		// FIFO Count Register
		VADDR_T	gsc_fdr_8;		// FIFO Data Register
		VADDR_T	gsc_fsr_32;		// FIFO Size Register
		VADDR_T	gsc_psrcr_32;	// Pin Source Reg
		VADDR_T	gsc_pstsr_32;	// Pin Status Register
		VADDR_T	gsc_rar_32;		// Rx Almost Reg
		VADDR_T	gsc_rcr_32;		// Rx Count Reg
		VADDR_T	gsc_sbr_32;		// Sync Byte Register
		VADDR_T	gsc_tar_32;		// Tx Almost Reg
		VADDR_T	gsc_tcr_32;		// Tx Count Reg

		VADDR_T	usc_regs;		// Base of USC registers.
		VADDR_T	usc_bcr;		// Bus Configuration Reg

		VADDR_T	usc_ccar_lb;	// Channel Command/Address Register, Lower Byte
		VADDR_T	usc_ccar_ub;	// Channel Command/Address Register, Upper Byte
		VADDR_T	usc_ccsr_ub;	// Channel Command/Status Register, Upper Byte
		VADDR_T	usc_dccr_lb;	// Daisy Chain Control Register, Lower Byte
		VADDR_T	usc_icr_lb;		// Interrupt Control Register, Lower Byte
		VADDR_T	usc_misr_lb;	// Miscellaneous Interrupt Control Register, Lower Byte
		VADDR_T	usc_misr_ub;	// Miscellaneous Interrupt Control Register, Upper Byte
		VADDR_T	usc_rccr_lb;	// Receive Character Count Register, Lower Byte
		VADDR_T	usc_rccr_ub;	// Receive Character Count Register, Upper Byte
		VADDR_T	usc_rcsr_lb;	// Receive Control/Status Register, Lower Byte
		VADDR_T	usc_ricr_lb;	// Receive Interrupt Control Register, Lower Byte
		VADDR_T	usc_sicr_lb;	// Status Interrupt Control Register, Lower Byte
		VADDR_T	usc_sicr_ub;	// Status Interrupt Control Register, Upper Byte
		VADDR_T	usc_tcsr_lb;	// Transmit Control/Status Register, Lower Byte
		VADDR_T	usc_ticr_lb;	// Transmit Interrupt Control Register, Lower Byte
	} vaddr;

};

struct _dev_data_t
{
	os_pci_t*			pci;			// The kernel PCI device descriptor.
	os_data_t			os;
	os_spinlock_t		spinlock;		// Control ISR access.
	os_sem_t			sem;			// Control thread access.
	gsc_dev_type_t		board_type;		// Corresponds to basic board type.
	const char*			model;			// Base model number in upper case.
	int					board_index;	// Index of the board being accessed.
	char				model_buf[32];	// i.e. "SIO4"
	char				proc_id_str[8];	// In the form of 0xX.

	os_bar_t			plx;			// PLX registers in memory space.
	os_bar_t			gsc;			// GSC registers in memory space.

	chan_data_t			channel[GSC_DEVS_PER_BOARD];
	gsc_dma_t			dma;			// For DMA based I/O.
	gsc_irq_t			irq;			// For interrupts.

	union
	{
		// The value of features.osc_chip controls selection.
		osc_cy22393_sio4_t	cy22393;
		osc_fixed_t			fixed;
		osc_idc2053b_t		idc2053b;
		osc_unknown_t		unknown;
	} osc;

	struct
	{
		s32				board_reset;	// BCR D8: Rx FIFO Stop On Full?
		s32				bus_speed;		// 33 or 66 (MHz)
		s32				bus_width;		// 32 or 64 (bits)

		s32				channel_qty;	// 4 or 8

		s32				device_qty;		// SIO8 = 2, SIO4 = 1
		s32				dmdma_scd;		// BCR D3/D7: DMDMA Single Cycle Disable?

		s32				fifo_size_total;// Total FIFO Size
		s32				fifo_space_cfg;	// FIFO Space COnfig
		s32				form_factor;	// Form Factor
		s32				fw_type;		// Firmware Type
		s32				fw_type_config;	// Yes or No

		u32				gsc_fr_32;		// Features Register
		u32				gsc_frr_32;		// Firmware Revision Register

		s32				index_subdevice;// SIO4: -1, SIO8: 0, 1
		s32				irq_32;			// Is the ICR 32 bits? If no, then 16.
		u32				irq_mask;		// 0xFFFFFFFF or 0x0000FFFF

		s32				led_channel;	// Channel specific LEDs
		s32				led_main;		// Common LEDs
		s32				legacy_cable;	// Legacy Cable Control: Supported?

		sio4_model_t	model;			// SIO4_MODEL_SIOXXX_XXX
		s32				model_sync;		// Is this a SYNC model board?
		s32				model_z16c30;	// Is this a Z16C30 model board?
		sio4_mp_chip_t	mp_chip;		// Which MP chip is present?

		s32				osc_chip;		// sio4_osc_chip_t
		s32				osc_measure;	// Can the osc rate be measured?
		s32				osc_pd_max;		// Maximum Post Divider value.
		s32				osc_per_chan;	// Is there an osc output per channel?
		s32				osc_program;	// Is the oscillator programmable?

		s32				reg_bsr;		// Board Status Register: Supported?
		s32				reg_fcr;		// FIFO Count Registers: Supported?
		s32				reg_fr;			// Features Register: Supported?
		s32				reg_fsr;		// FIFO Size Registers: Supported?
		s32				reg_ftr;		// Firmware Type Register: Supported
		s32				reg_ielr;		// IRQ Edge/Level Register: Supported?
		u32				reg_ielr_32;	// Value from Int Edge/Level Register
		s32				reg_ihlr;		// IRQ High/Low Register: Supported?
		s32				reg_iocr;		// I/O Control Register: Supported?
		s32				reg_pcr;		// Prog Clock Register: Supported?
		s32				reg_pocsr;		// Prog Osc Control/Status Reg: Supported?
		s32				reg_porar;		// Prog Osc RAM Adrs Reg: Supported?
		s32				reg_pordr;		// Prog Osc RAM Data Reg: Supported?
		s32				reg_pord2r;		// Prog Osc RAM Data 2 Reg: Supported?
		s32				reg_tsr;		// Time Stamp Register: Supported?

		s32				rx_fifo_full_cfg_glb;	// BCR D8: Rx FIFO Stop On Full? GLOBAL
		s32				rx_fifo_underrun;	// CSR D18: Rx FIFO Underrun?

		s32				sio4_type;			// sio4_type_t

		s32				time_stamp;			// SIO4BXR & rev >= 0x06
		s32				tx_fifo_overrun;	// CSR D17: Tx FIFO Overrun?

		s32				user_jumper_qty;	// >= 0
		s32				user_jumper_sense;	// 1: "1" = on, 0: "0" = on
		s32				user_jumper_val;	// The value from the jumpers.

	} cache;

	struct
	{
		VADDR_T			plx_intcsr_32;	// Interrupt Control/Status Register
		VADDR_T			plx_dmaarb_32;	// DMA Arbitration Register
		VADDR_T			plx_dmathr_32;	// DMA Threshold Register

		VADDR_T			gsc_bcr_32;		// Board Control Reg
		VADDR_T			gsc_bsr_32;		// Board Status Register
		VADDR_T			gsc_ccr_32;		// Clock Control Reg
		VADDR_T			gsc_fr_32;		// Features Register
		VADDR_T			gsc_frr_32;		// Firmware Revision Register
		VADDR_T			gsc_ftr_32;		// Firmware Type Register
		VADDR_T			gsc_icr_32;		// Interrupt Control Register
		VADDR_T			gsc_ielr_32;	// Int Edge/Level Reg
		VADDR_T			gsc_ihlr_32;	// Int Hi/Low Reg
		VADDR_T			gsc_iocr_32;	// I/O COntrol Register.
		VADDR_T			gsc_isr_32;		// Interrupt Status Register
		VADDR_T			gsc_pocsr_32;	// Prog Osc Ctrl/Sts Reg
		VADDR_T			gsc_porar_32;	// Prog Osc RAM Adrs Reg
		VADDR_T			gsc_pordr_32;	// Prog Osc RAM Data Reg
		VADDR_T			gsc_pord2r_32;	// Prog Osc RAM Data 2 Reg
		VADDR_T			gsc_tsr_32;		// Time Stamp Register
	} vaddr;

};



// prototypes *****************************************************************

int		dev_dma_chan_setup(chan_data_t* chan, gsc_dma_ch_t* dma, u32 dpr);
void	dev_io_close(GSC_ALT_STRUCT_T* alt);
int		dev_io_create(dev_data_t* dev, int channel);
void	dev_io_destroy(dev_data_t* dev, int channel);
int		dev_io_open(GSC_ALT_STRUCT_T* alt);
int		dev_irq_create(dev_data_t* dev);
void	dev_irq_destroy(dev_data_t* dev);
long	dma_read_available(GSC_ALT_STRUCT_T* alt, size_t count);
long	dma_read_work(GSC_ALT_STRUCT_T* alt, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
long	dma_write_available(GSC_ALT_STRUCT_T* alt, size_t count);
long	dma_write_work(GSC_ALT_STRUCT_T* alt, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
long	dmdma_read_available(GSC_ALT_STRUCT_T* alt, size_t count);
long	dmdma_read_work(GSC_ALT_STRUCT_T* alt, const os_mem_t* mem, size_t count, os_time_tick_t st_end);
long	dmdma_write_available(GSC_ALT_STRUCT_T* alt, size_t count);
long	dmdma_write_work(GSC_ALT_STRUCT_T* alt, const os_mem_t* mem, size_t count, os_time_tick_t st_end);

int		fw_type_config_get(chan_data_t* chan, s32* get);		// ioctl.c

int		initialize_ioctl(chan_data_t* chan, s32* arg);

long	pio_read_available(GSC_ALT_STRUCT_T* alt, size_t count);
long	pio_write_available(GSC_ALT_STRUCT_T* alt, size_t count);

void	reg_mod(chan_data_t* chan, u32 reg, u32 value, u32 mask);
void	reg_read(chan_data_t* chan, u32 reg, u32* value);
void	reg_write(chan_data_t* chan, u32 reg, u32 value);



#endif
