// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/utils/async_util_show.c $
// $Rev: 33928 $
// $Date: 2015-10-07 15:07:40 -0500 (Wed, 07 Oct 2015) $

#include "sio4_async_utils.h"



//*****************************************************************************
int async_util_show(int fd, int index, int verbose, const sio4_async_t* async, const char** err)
{
	int			errs;
	const char*	psz;
	int			ret;

	if (err == NULL)
		err	= &psz;

	if (verbose)
	{
		gsc_label_index("Asynchronous Show", index);
		printf("...\n");
	}

	ret		= sio4_async_show(fd, async, err);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
	{
	}
	else if (errs)
	{
		gsc_label_index("Asynchronous Show", index);
		printf("FAIL <---  (sio4_async_show, %s)\n", err[0]);
	}
	else
	{
		gsc_label_index("Asynchronous Show", index);
		printf("PASS\n");
	}

	return(errs);
}


