// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/write.c $
// $Rev: 33919 $
// $Date: 2015-10-07 14:43:18 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _args_validate(int fd, const void* buf, size_t size, device_t** dev)
{
	int	ret;

	for (;;)	// A convenience loop.
	{
		if (buf == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		if (size < 0)
		{
			ret	= -EINVAL;
			break;
		}

		if (dev == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		dev[0]	= lib_fd_find_inc(fd);

		if (dev[0] == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		ret	= 0;
		break;
	}

	return(ret);
}



//*****************************************************************************
static int _env_validate(device_t* dev)
{
	int	ret;

	ret	= dev->tx.writing ? -EBUSY : 0;
	return(ret);
}



//*****************************************************************************
static int _loc_write(device_t* dev, const void* buf, size_t size)
{
	int	ret;

	ret	= sio4_write(dev->fd, buf, size);
	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_async_write
*
*	Purpose:
*
*		Send out a block of data.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		buf		The source for teh data to write.
*
*		size	The number of bytes to write.
*
*	Returned:
*
*		>= 0	The number of bytes read.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_async_write(int fd, const void* buf, size_t size)
{
	device_t*	dev		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_async_lib_init();

		if (ret)
			break;

		// Validate the arguments.
		ret	= _args_validate(fd, buf, size, &dev);

		if (ret)
			break;

		// Gain exclusive access to the device.
		ret	= os_sem_lock(&dev->sem);

		if (ret)
			break;

		// Validate the state.
		ret	= _env_validate(dev);

		if (ret)
		{
			os_sem_unlock(&dev->sem);
			break;
		}

		// Gain exclusive access to the Tx stream.
		ret	= os_sem_lock(&dev->tx.sem);
		os_sem_unlock(&dev->sem);

		if (ret)
			break;

		// Record our presence.
		dev->tx.writing	= 1;
		os_sem_unlock(&dev->tx.sem);

		// Perform the operation.
		ret	= _loc_write(dev, buf, size);

		// Cleanup.
		dev->tx.writing	= 0;
		break;
	}

	if (dev)
		lib_dev_dec(dev);

	return(ret);
}


