// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/usc_tx_stop_bits.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC Tx Stop Bits");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1:

			ptr	= "1 Stop Bit";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_2:

			ptr	= "2 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0__9_16:

			ptr	= "9/16 of a Stop Bit";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0_10_16:

			ptr	= "10/16 of a Stop Bit (5/8)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0_11_16:

			ptr	= "11/16 of a Stop Bit";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0_12_16:

			ptr	= "12/16 of a Stop Bit (3/4)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0_13_16:

			ptr	= "13/16 of a Stop Bit";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0_14_16:

			ptr	= "14/16 of a Stop Bit (7/8)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_0_15_16:

			ptr	= "15/16 of a Stop Bit";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__1_16:

			ptr	= "1 and 1/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__2_16:

			ptr	= "1 and 2/16 Stop Bits (1+1/8)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__3_16:

			ptr	= "1 and 3/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__4_16:

			ptr	= "1 and 4/16 Stop Bits (1+1/4)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__5_16:

			ptr	= "1 and 5/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__6_16:

			ptr	= "1 and 6/16 Stop Bits (1+3/8)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__7_16:

			ptr	= "1 and 7/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__8_16:

			ptr	= "1 and 8/16 Stop Bits (1+1/2)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1__9_16:

			ptr	= "1 and 9/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1_10_16:

			ptr	= "1 and 10/16 Stop Bits (1+5/8)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1_11_16:

			ptr	= "1 and 11/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1_12_16:

			ptr	= "1 and 12/16 Stop Bits (1+3/4)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1_13_16:

			ptr	= "1 and 13/16 Stop Bits";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1_14_16:

			ptr	= "1 and 14/16 Stop Bits (1+7/8)";
			break;

		case SIO4_ASYNC_USC_TX_STOP_BIT_1_15_16:

			ptr	= "1 and 15/16 Stop Bits";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_async_t_usc_tx_stop_bits(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->usc.tx.stop_bits"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_async_tx_stop_bit(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_USC_TX_STOP_BIT_1;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_async_tx_stop_bit(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:			errs	= 1;			break;
					case -1:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1:
					case SIO4_ASYNC_USC_TX_STOP_BIT_2:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0__9_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0_10_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0_11_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0_12_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0_13_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0_14_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_0_15_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__1_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__2_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__3_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__4_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__5_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__6_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__7_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__8_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1__9_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1_10_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1_11_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1_12_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1_13_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1_14_16:
					case SIO4_ASYNC_USC_TX_STOP_BIT_1_15_16:	break;
				}
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


