// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/usc_rx_rxc.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC RxC");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ASYNC_USC_RX_RXC_IN_OSC:

			ptr	= "Input the Oscillator";
			break;

		case SIO4_ASYNC_USC_RX_RXC_IN_OSC_INV:

			ptr	= "Input the Inverted Oscillator";
			break;

		case SIO4_ASYNC_USC_RX_RXC_IN_0:

			ptr	= "Input A Low";
			break;

		case SIO4_ASYNC_USC_RX_RXC_IN_1:

			ptr	= "Input A High";
			break;

		case SIO4_ASYNC_USC_RX_RXC_IN_CBL_RXC:

			ptr	= "Input from the Cable RxC Pin";
			break;

		case SIO4_ASYNC_USC_RX_RXC_IN_CBL_RXAUX:

			ptr	= "Input from the Cable RxAuxC pin";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_CLK:

			ptr	= "Output the Rx Clock";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_BYTE_CLK:

			ptr	= "Output the Rx Byte Clock";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_SYNC:

			ptr	= "Output the Rx Sync signal";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_BRG0:

			ptr	= "Output the BRG0 Output";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_BRG1:

			ptr	= "Output the BRG1 Output";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_CTR0:

			ptr	= "Output the CTR0 Output";
			break;

		case SIO4_ASYNC_USC_RX_RXC_OUT_DPLL_RX:

			ptr	= "Output the DPLL's Rx Clock";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_async_t_usc_rx_rxc(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->usc.rx.rxc"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_rxc_cfg(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_USC_RX_RXC_IN_OSC;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_rxc_cfg(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:				errs	= 1;	break;
					case -1:
					case SIO4_ASYNC_USC_RX_RXC_IN_OSC:
					case SIO4_ASYNC_USC_RX_RXC_IN_OSC_INV:
					case SIO4_ASYNC_USC_RX_RXC_IN_0:
					case SIO4_ASYNC_USC_RX_RXC_IN_1:
					case SIO4_ASYNC_USC_RX_RXC_IN_CBL_RXC:
					case SIO4_ASYNC_USC_RX_RXC_IN_CBL_RXAUX:
					case SIO4_ASYNC_USC_RX_RXC_OUT_CLK:
					case SIO4_ASYNC_USC_RX_RXC_OUT_BYTE_CLK:
					case SIO4_ASYNC_USC_RX_RXC_OUT_SYNC:
					case SIO4_ASYNC_USC_RX_RXC_OUT_BRG0:
					case SIO4_ASYNC_USC_RX_RXC_OUT_BRG1:
					case SIO4_ASYNC_USC_RX_RXC_OUT_CTR0:
					case SIO4_ASYNC_USC_RX_RXC_OUT_DPLL_RX:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


