// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/tx_io_timeout.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Tx I/O Timeout");

	if (set == -1)
	{
		printf("This service is not supported by this board.\n");
	}
	else if ((set < SIO4_ASYNC_RX_IO_TIMEOUT_MIN) || (set > SIO4_ASYNC_RX_IO_TIMEOUT_MAX))
	{
		errs++;
		printf("Invalid value: %ld\n", (long) set);
	}
	else
	{
		gsc_label_long_comma(set);
		printf(" seconds\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_async_t_tx_io_timeout(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->tx.io.timeout"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_tx_io_timeout(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_TX_IO_TIMEOUT_DEFAULT;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_tx_io_timeout(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				if ((arg[0] != -1) &&
					(	(arg[0] < SIO4_ASYNC_TX_IO_TIMEOUT_MIN) ||
						(arg[0] > SIO4_ASYNC_TX_IO_TIMEOUT_MAX)))
				{
					errs	= 1;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


