// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/tx_io_pio_thresh.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Tx I/O Pio Threshold");

	if (set == -1)
	{
		printf("This service is not supported by this board.\n");
	}
	else if (set < 0)
	{
		errs++;
		printf("Invalid value: %ld\n", (long) set);
	}
	else
	{
		gsc_label_long_comma(set);
		printf(" samples\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_async_t_tx_io_pio_thresh(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->tx.io.pio_thresh"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_tx_io_pio_threshold(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= 64;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_tx_io_pio_threshold(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				if (arg[0] < -1)
					errs	= 1;

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


