// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/tx_idle_cond.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC Tx Idle Condition");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_DEFAULT:

			ptr	= "Default";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_0_1:

			ptr	= "Alternating 0's and 1's";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_0:

			ptr	= "Continuous 0's";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_1:

			ptr	= "Continuous 1's";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_MARK_SPACE:

			ptr	= "Alternating Mark's and Space's";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_SPACE:

			ptr	= "Continuous Space's";
			break;

		case SIO4_ASYNC_TX_IDLE_COND_MARK:

			ptr	= "Continuous Mark's";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_async_t_tx_idle_cond(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->tx.idle_cond"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_tx_idle_cond(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_TX_IDLE_COND_DEFAULT;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_tx_idle_cond(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:				errs	= 1;	break;
					case -1:
					case SIO4_ASYNC_TX_IDLE_COND_DEFAULT:
					case SIO4_ASYNC_TX_IDLE_COND_0_1:
					case SIO4_ASYNC_TX_IDLE_COND_0:
					case SIO4_ASYNC_TX_IDLE_COND_1:
					case SIO4_ASYNC_TX_IDLE_COND_MARK_SPACE:
					case SIO4_ASYNC_TX_IDLE_COND_SPACE:
					case SIO4_ASYNC_TX_IDLE_COND_MARK:		break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


