// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/tx_enable.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC Tx Enable");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ASYNC_TX_ENABLE_NO_NOW:

			ptr	= "No, Disable Immediately";
			break;

		case SIO4_ASYNC_TX_ENABLE_NO_AFTER:

			ptr	= "No, Disable after current character";
			break;

		case SIO4_ASYNC_TX_ENABLE_YES_NOW:

			ptr	= "Yes, Enable Immediately";
			break;

		case SIO4_ASYNC_TX_ENABLE_YES_W_AE:

			ptr	= "Yes, Auto-enable flow control signals";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_async_t_tx_enable(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->tx.enable"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_tx_enable(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_TX_ENABLE_YES_NOW;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_tx_enable(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:			errs	= 1;	break;
					case -1:
					case SIO4_ASYNC_TX_ENABLE_NO_NOW:
					case SIO4_ASYNC_TX_ENABLE_NO_AFTER:
					case SIO4_ASYNC_TX_ENABLE_YES_NOW:
					case SIO4_ASYNC_TX_ENABLE_YES_W_AE:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


