// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/tx_bit_rate.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Tx Bit Rate");

	if (set == -1)
	{
		printf("This service is not supported by this board.\n");
	}
	else if (set < 0)
	{
		errs++;
		printf("Invalid value: %ld\n", (long) set);
	}
	else if (set == 0)
	{
		printf("Not recorded for later retrieval (0).\n");
	}
	else
	{
		gsc_label_long_comma(set);
		printf(" b/s\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_async_t_tx_bit_rate(
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->tx.bit_rate"
	int			errs	= 0;
	const char*	sts		= NULL;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				// Not recorded for later retrieval.
				arg[0]	= 0;
				break;

		case SIO4_ASYNC_ACTION_INIT:

				// Not recorded for later retrieval.
				arg[0]	= 0;
				break;

		case SIO4_ASYNC_ACTION_SET:

				// We do nothing here.
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				if ((arg[0] < -1) || (arg[0] > 1250000))
					errs	= 1;

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


