// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/sio4_async_t.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
const char* sio4_async_t_access(device_t* dev, sio4_async_t* async, sio4_async_action_t action)
{
	s32			arg;
	const char*	err		= NULL;
	int			errs;
	s32			fw		= 0;
	int			ret;

	for (;;)	// A convenience loop.
	{
		if (dev == NULL)
		{
			err	= "sio4_async_t_access(dev,,)";
			break;
		}

		if (async == NULL)
		{
			err	= "sio4_async_t_access(,async,)";
			break;
		}

		// Verify that this is a Z16C30 based board.
		errs	= sio4_query(dev->fd, SIO4_QUERY_FW_TYPE, &fw);

		if (errs)
		{
			err	= "sio4_query()";
			break;
		}

		if (fw != SIO4_FW_TYPE_Z16C30)
		{
			err	= "This is not a Z16C30 based SIO4.";
			break;
		}

		switch (action)
		{
			default:

				err	= "sio4_async_t_access(,,action)";
				break;

			case SIO4_ASYNC_ACTION_SHOW:

				gsc_label("sio4_async_t Settings");
				printf("\n");
				gsc_label_level_inc();
				break;

			case SIO4_ASYNC_ACTION_SET:

				// Initialize various settings before applying user settings.

				arg	= SIO4_ASYNC_TX_ENABLE_NO_NOW;
				sio4_async_t_tx_enable				(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_RX_ENABLE_NO_NOW;
				sio4_async_t_rx_enable				(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_CABLE_ENABLE_NO;
				sio4_async_t_cable_enable			(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_CABLE_PROTOCOL_DISABLE;
				sio4_async_t_cable_protocol			(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_LOOPBACK_MODE_DISABLE;
				sio4_async_t_cable_loopback_mode	(dev->fd, &arg,	action, &err);

				arg	= SIO4_ASYNC_CABLE_TERM_ENABLE_NO;
				sio4_async_t_cable_term_enable		(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_CABLE_LEGACY_TXC_DISABLE;
				sio4_async_t_cable_legacy_txc		(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_CABLE_LEGACY_TXD_CTS_TRI;
				sio4_async_t_cable_legacy_txd_cts	(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_CABLE_LEGACY_RXC_DISABLE;
				sio4_async_t_cable_legacy_rxc		(dev->fd, &arg, action, &err);

				arg	= SIO4_ASYNC_CABLE_LEGACY_RXD_DCD_DISABLE;
				sio4_async_t_cable_legacy_rxd_dcd	(dev->fd, &arg, action, &err);

				break;

			case SIO4_ASYNC_ACTION_GET:
			case SIO4_ASYNC_ACTION_INIT:
			case SIO4_ASYNC_ACTION_VERIFY:

				break;
		}

		if (err)
			break;

		sio4_async_t_osc_ref				(dev->fd, &async->osc.ref,					action, &err);
		sio4_async_t_osc_prog				(dev->fd, &async->osc.prog,					action, &err);

		sio4_async_t_usc_mode				(dev->fd, &async->usc.mode,					action, &err);
		sio4_async_t_usc_txd				(dev->fd, &async->usc.txd,					action, &err);
		sio4_async_t_usc_cts				(dev->fd, &async->usc.cts,					action, &err);
		sio4_async_t_usc_cts_legacy			(dev->fd, &async->usc.cts_legacy,			action, &err);
		sio4_async_t_usc_dcd				(dev->fd, &async->usc.dcd,					action, &err);
		sio4_async_t_usc_dcd_legacy			(dev->fd, &async->usc.dcd_legacy,			action, &err);
		sio4_async_t_usc_tx_clk_rate		(dev->fd, &async->usc.tx.clk_rate,			action, &err);
		sio4_async_t_usc_tx_clk_src			(dev->fd, &async->usc.tx.clk_src,			action, &err);
		sio4_async_t_usc_tx_stop_bits		(dev->fd, &async->usc.tx.stop_bits,			action, &err);
		sio4_async_t_usc_tx_txc				(dev->fd, &async->usc.tx.txc,				action, &err);
		sio4_async_t_usc_tx_txc_legacy		(dev->fd, &async->usc.tx.txc_legacy,		action, &err);
		sio4_async_t_usc_rx_clk_rate		(dev->fd, &async->usc.rx.clk_rate,			action, &err);
		sio4_async_t_usc_rx_clk_src			(dev->fd, &async->usc.rx.clk_src,			action, &err);
		sio4_async_t_usc_rx_rxc				(dev->fd, &async->usc.rx.rxc,				action, &err);
		sio4_async_t_usc_rx_rxc_legacy		(dev->fd, &async->usc.rx.rxc_legacy,		action, &err);
		sio4_async_t_usc_brg0_enable		(dev->fd, &async->usc.brg0.enable,			action, &err);
		sio4_async_t_usc_brg0_clk_src		(dev->fd, &async->usc.brg0.clk_src,			action, &err);
		sio4_async_t_usc_brg0_divider		(dev->fd, &async->usc.brg0.divider,			action, &err);
		sio4_async_t_usc_brg0_mode			(dev->fd, &async->usc.brg0.mode,			action, &err);
		sio4_async_t_usc_brg1_enable		(dev->fd, &async->usc.brg1.enable,			action, &err);
		sio4_async_t_usc_brg1_clk_src		(dev->fd, &async->usc.brg1.clk_src,			action, &err);
		sio4_async_t_usc_brg1_divider		(dev->fd, &async->usc.brg1.divider,			action, &err);
		sio4_async_t_usc_brg1_mode			(dev->fd, &async->usc.brg1.mode,			action, &err);
		sio4_async_t_usc_ctr0_clk_src		(dev->fd, &async->usc.ctr0.clk_src,			action, &err);
		sio4_async_t_usc_ctr0_rate			(dev->fd, &async->usc.ctr0.rate,			action, &err);
		sio4_async_t_usc_ctr1_clk_src		(dev->fd, &async->usc.ctr1.clk_src,			action, &err);
		sio4_async_t_usc_ctr1_rate_src		(dev->fd, &async->usc.ctr1.rate_src,		action, &err);
		sio4_async_t_usc_dpll_rate			(dev->fd, &async->usc.dpll.rate,			action, &err);

		sio4_async_t_tx_mode				(dev->fd, &async->tx.mode,					action, &err);
		sio4_async_t_tx_char_len			(dev->fd, &async->tx.char_len,				action, &err);
		sio4_async_t_tx_encoding			(dev->fd, &async->tx.encoding,				action, &err);
		sio4_async_t_tx_idle_cond			(dev->fd, &async->tx.idle_cond,				action, &err);
		sio4_async_t_tx_parity_enable		(dev->fd, &async->tx.parity.enable,			action, &err);
		sio4_async_t_tx_parity_type			(dev->fd, &async->tx.parity.type,			action, &err);
		sio4_async_t_tx_fifo_size			(dev->fd, &async->tx.fifo.size,				action, &err);
		sio4_async_t_tx_fifo_ae				(dev->fd, &async->tx.fifo.ae,				action, &err);
		sio4_async_t_tx_fifo_af				(dev->fd, &async->tx.fifo.af,				action, &err);
		sio4_async_t_tx_fifo_empty_cfg		(dev->fd, &async->tx.fifo.empty_cfg,		action, &err);
		sio4_async_t_tx_fifo_space_cfg		(dev->fd, &async->tx.fifo.space_cfg,		action, &err);
		sio4_async_t_tx_io_mode				(dev->fd, &async->tx.io.mode,				action, &err);
		sio4_async_t_tx_io_pio_thresh		(dev->fd, &async->tx.io.pio_thresh,			action, &err);
		sio4_async_t_tx_io_timeout			(dev->fd, &async->tx.io.timeout,			action, &err);
		sio4_async_t_tx_io_overrun			(dev->fd, &async->tx.io.overrun,			action, &err);
		sio4_async_t_tx_enable				(dev->fd, &async->tx.enable,				action, &err);
		sio4_async_t_tx_bit_rate			(		  &async->tx.bit_rate,				action, &err);

		sio4_async_t_rx_mode				(dev->fd, &async->rx.mode,					action, &err);
		sio4_async_t_rx_char_len			(dev->fd, &async->rx.char_len,				action, &err);
		sio4_async_t_rx_encoding			(dev->fd, &async->rx.encoding,				action, &err);
		sio4_async_t_rx_parity_enable		(dev->fd, &async->rx.parity.enable,			action, &err);
		sio4_async_t_rx_parity_type			(dev->fd, &async->rx.parity.type,			action, &err);
		sio4_async_t_rx_fifo_size			(dev->fd, &async->rx.fifo.size,				action, &err);
		sio4_async_t_rx_fifo_ae				(dev->fd, &async->rx.fifo.ae,				action, &err);
		sio4_async_t_rx_fifo_af				(dev->fd, &async->rx.fifo.af,				action, &err);
		sio4_async_t_rx_fifo_full_cfg		(dev->fd, &async->rx.fifo.full_cfg,			action, &err);
		sio4_async_t_rx_io_mode				(dev->fd, &async->rx.io.mode,				action, &err);
		sio4_async_t_rx_io_pio_thresh		(dev->fd, &async->rx.io.pio_thresh,			action, &err);
		sio4_async_t_rx_io_timeout			(dev->fd, &async->rx.io.timeout,			action, &err);
		sio4_async_t_rx_io_overrun			(dev->fd, &async->rx.io.overrun,			action, &err);
		sio4_async_t_rx_io_underrun			(dev->fd, &async->rx.io.underrun,			action, &err);
		sio4_async_t_rx_sync_byte			(dev->fd, &async->rx.sync_byte,				action, &err);
		sio4_async_t_rx_status_word			(dev->fd, &async->rx.status_word,			action, &err);
		sio4_async_t_rx_time_stamp_enable	(dev->fd, &async->rx.time_stamp.enable,		action, &err);
		sio4_async_t_rx_time_stamp_clk_src	(dev->fd, &async->rx.time_stamp.clk_src,	action, &err);
		sio4_async_t_rx_enable				(dev->fd, &async->rx.enable,				action, &err);
		sio4_async_t_rx_bit_rate			(		  &async->rx.bit_rate,				action, &err);

		if (action == SIO4_ASYNC_ACTION_SET)
		{
			// Clear the transmit side.
			arg	= 1;
			ret	= sio4_async_ioctl(dev->fd, SIO4_IOCTL_TX_FIFO_RESET, &arg);
			err	= err ? err : ret ? "SIO4_IOCTL_TX_FIFO_RESET" : NULL;

			arg	= SIO4_USC_SEND_CMD_TX_FIFO_PURGE;
			ret	= sio4_async_ioctl(dev->fd, SIO4_IOCTL_USC_SEND_COMMAND, &arg);
			err	= err ? err : ret ? "SIO4_USC_SEND_CMD_TX_FIFO_PURGE" : NULL;

			// Clear the receive side.
			arg	= SIO4_USC_SEND_CMD_RX_FIFO_PURGE;
			ret	= sio4_async_ioctl(dev->fd, SIO4_IOCTL_USC_SEND_COMMAND, &arg);
			err	= err ? err : ret ? "SIO4_USC_SEND_CMD_RX_FIFO_PURGE" : NULL;

			arg	= 1;
			ret	= sio4_async_ioctl(dev->fd, SIO4_IOCTL_RX_FIFO_RESET, &arg);
			err	= err ? err : ret ? "SIO4_IOCTL_RX_FIFO_RESET" : NULL;
		}

		sio4_async_t_cable_txaux			(dev->fd, &async->cable.txaux,			action, &err);
		sio4_async_t_cable_txc				(dev->fd, &async->cable.txc,			action, &err);
		sio4_async_t_cable_legacy_txc		(dev->fd, &async->cable.legacy.txc,		action, &err);
		sio4_async_t_cable_txd				(dev->fd, &async->cable.txd,			action, &err);
		sio4_async_t_cable_legacy_txd_cts	(dev->fd, &async->cable.legacy.txd_cts,	action, &err);
		sio4_async_t_cable_rts				(dev->fd, &async->cable.rts,			action, &err);
		sio4_async_t_cable_dcd				(dev->fd, &async->cable.dcd,			action, &err);
		sio4_async_t_cable_legacy_rxd_dcd	(dev->fd, &async->cable.legacy.rxd_dcd,	action, &err);
		sio4_async_t_cable_dtr_dsr			(dev->fd, &async->cable.dtr_dsr,		action, &err);
		sio4_async_t_cable_legacy_rxc		(dev->fd, &async->cable.legacy.rxc,		action, &err);

		sio4_async_t_cable_mode				(dev->fd, &async->cable.mode,			action, &err);
		sio4_async_t_cable_protocol			(dev->fd, &async->cable.protocol,		action, &err);
		sio4_async_t_cable_loopback_mode	(dev->fd, &async->cable.loopback.mode,	action, &err);
		sio4_async_t_cable_term_enable		(dev->fd, &async->cable.term.enable,	action, &err);
		sio4_async_t_cable_enable			(dev->fd, &async->cable.enable,			action, &err);

		switch (action)
		{
			case SIO4_ASYNC_ACTION_GET:
			case SIO4_ASYNC_ACTION_INIT:
			case SIO4_ASYNC_ACTION_SET:
			case SIO4_ASYNC_ACTION_VERIFY:
			default:

				break;

			case SIO4_ASYNC_ACTION_SHOW:

				gsc_label_level_dec();
				break;
		}

		break;
	}

	return(err);
}


