// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/set.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_async_set
*
*	Purpose:
*
*		Apply the provided Asynchronous settings to the specified SIO4.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		async	The settings to apply.
*
*		err		If a field value is invalid, this will name the field.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_async_set(int fd, const sio4_async_t* async, const char** err)
{
	device_t*	dev;
	const char*	psz		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_async_lib_init();

		if (ret)
		{
			psz	= "sio4_async_lib_init";
			break;
		}

		// Validate the received arguments.

		if (async == NULL)
		{
			psz	= "sio4_async_set(,async,)";
			break;
		}

		// Gain access to the device.
		dev	= lib_fd_find_inc(fd);

		if (dev == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		// Begin working.
		psz	= sio4_async_t_access(dev, (sio4_async_t*) async, SIO4_ASYNC_ACTION_VERIFY);

		if (psz == NULL)
			psz	= sio4_async_t_access(dev, (sio4_async_t*) async, SIO4_ASYNC_ACTION_SET);

		if (psz)
			ret	= -EINVAL;

		lib_dev_dec(dev);
		break;
	}

	if (err)
		err[0]	= psz;

	return(ret);
}


